package localstore.api;

import localstore.dto.ProviderGoodsStockVo;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * Created by Cheng Haitao on 2018-08-15.
 */
//商品服务接口
public interface LocalStoreApi {
    /**
     * 商品上下架查询接口
     *
     * @param skus，storeId
     * @return
     */
    BaseResponse queryGoodsShelves(List<String> skus, String storeId);

    /**
     * 商品价格接口
     *
     * @param skus，storeId
     * @return
     */
    BaseResponse queryGoodsPrice(List<String> skus, String storeId);

    /**
     * 查询库存接口
     *
     * @param skus，storeId
     * @return
     */
    BaseResponse queryGoodsStock(List<String> skus, String storeId);

    /**
     * 预占库存接口
     *
     * @param sku，storeId，count
     * @return
     */
    BaseResponse occupyStock(String sku, String storeId,Integer count);

    /**
     * 确认下单接口
     *
     * @param orderNo
     * @return
     */
    BaseResponse confirmOrder(String orderNo);

    /**
     * 查询订单状态
     * @param trdOrderNo
     * @return
     */
    BaseResponse findOrderStatus(String trdOrderNo,String storeId);

    /**
     * 查询订单物流
     * @param orderNo
     * @return
     */
    BaseResponse findOrderLogistics(String orderNo);

}
