package localstore.api;

import localstore.dto.LocalStoreOrderVo;
import localstore.dto.ProviderGoodsStockVo;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * Created by Cheng Haitao on 2018-08-15.
 */
//商品服务接口
public interface LocalStoreProductApi {
    /**
     * 商品上下架查询接口
     *
     * @param skus，storeId
     * @return
     */
    BaseResponse queryFashionStockState(List<String> skus, String storeId);

    /**
     * 商品价格接口
     *
     * @param skus，storeId
     * @return
     */
    BaseResponse queryFashionPrice(List<String> skus, String storeId);

    /**
     * 查询库存接口
     *
     * @param skus，storeId
     * @return
     */
    BaseResponse queryGoodsStock(List<String> skus, String storeId);

    /**
     * 预占库存接口
     *
     * @param localStoreOrderVo
     * @return
     */
    BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo);


    /**
     *  取消预占库存（取消订单 变更商品库存）
     * @param thrOrderNo
     * @param storedId
     * @return
     */
    BaseResponse cancelOccupyStock(String thrOrderNo, String storedId);

    /**
     * 确认下单接口
     *
     * @param orderNo
     * @return
     */
    BaseResponse confirmOrder(String orderNo);


    /**
     * 查询订单状态
     * @param orderNo
     * @return
     */
    BaseResponse findOrderStatus(String orderNo);

    /**
     * 查询订单物流记录
     * @param thirdOrderNo 第三方订单号
     * @return
     */
    BaseResponse findOrderLogistics(String thirdOrderNo);

}
