package localstore.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import localstore.api.LocalStoreApi;
import localstore.dto.ProviderGoodsStockVo;
import localstore.service.service.LocalStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;
import java.util.List;

/**
 * @author 张代春
 * @date 2018/8/16
 */
@MotanService
public class LocalStoreApiImpl implements LocalStoreApi {

    @Autowired
    LocalStoreService localStoreService;

    @Override
    public BaseResponse findOrderStatus(String trdOrderNo,String storeId) {
        return localStoreService.findOrderStatus(trdOrderNo,storeId);
    }

    @Override
    public BaseResponse findOrderLogistics(String orderNo) {
        // TODO: 2018/8/16  物流跟踪目前没有，先返回空
        return null;
    }

    @Override
    public  BaseResponse queryGoodsShelves(List<String> skus, String storeId){
        return localStoreService.queryGoods(skus,storeId);
    }

    @Override
    public BaseResponse queryGoodsPrice(List<String> skus, String storeId){
        return localStoreService.queryGoods(skus,storeId);
    }

    @Override
    public BaseResponse queryGoodsStock(List<String> skus, String storeId){
        return localStoreService.queryGoods(skus,storeId);
    }

    @Override
    public  BaseResponse occupyStock(String sku, String storeId,Integer count){
       return localStoreService.occupyStock(sku,storeId,count);
    }

    @Override
    public BaseResponse confirmOrder(String orderNo){
     return localStoreService.confirmOrder(orderNo);
    }
}
