package localstore.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import localstore.api.LocalStoreProductApi;
import localstore.dto.LocalStoreOrderVo;
import localstore.dto.ProviderGoodsStockVo;
import localstore.service.service.LocalStoreProductService;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;
import store.api.dto.mapdto.MallShippingDto;

import java.util.List;

/**
 * @author 张代春
 * @date 2018/8/16
 */
@MotanService
public class LocalStoreProductApiImpl implements LocalStoreProductApi {

    @Autowired
    LocalStoreProductService localStoreProductService;


    @Override
    public BaseResponse findOrderStatus(String orderNo) {
        return localStoreProductService.findOrderStatus(orderNo);
    }

    /**
     *  自营店铺查询物流
     * @param thirdOrderNo 第三方订单号
     * @return
     */
    @Override
    public BaseResponse<List<MallShippingDto>> findOrderLogistics(String thirdOrderNo) {
        // TODO: 2018/8/16  物流跟踪目前没有，先返回空
        List<MallShippingDto> orderLogistics = localStoreProductService.findOrderLogistics(thirdOrderNo);
        return new BaseResponse<>(true,"success",orderLogistics);
    }

    @Override
    public  BaseResponse queryFashionStockState(List<String> skus, String storeId){
        return localStoreProductService.queryGoods(skus,storeId);
    }

    @Override
    public BaseResponse queryFashionPrice(List<String> skus, String storeId){
        return localStoreProductService.queryGoods(skus,storeId);
    }

    @Override
    public BaseResponse queryGoodsStock(List<String> skus, String storeId){
        return localStoreProductService.queryGoods(skus,storeId);
    }

    @Override
    public  BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo){
       return localStoreProductService.occupyStock(localStoreOrderVo);
    }

    @Override
    public BaseResponse cancelOccupyStock(String thrOrderNo, String storedId) {
        return localStoreProductService.cancelOccupyStock(thrOrderNo,storedId);
    }

    @Override
    public BaseResponse confirmOrder(String orderNo){
     return localStoreProductService.confirmOrder(orderNo);
    }
}
