package localstore.service.service;


import cart.api.OrderMainApi;
import cart.api.SubOrderApi;
import cart.api.TrdSpOrderStatusApi;
import cart.api.dto.order.OrderMainDto;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import localstore.api.LocalStoreProductApi;
import localstore.dto.LocalStoreOpeatorVo;
import localstore.dto.LocalStoreOrderVo;
import localstore.service.utils.SequenceUtil;
import order.api.StoreOrderApi;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pool.commonUtil.MessageDictionary;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

/**
 * @author Sor
 * @date 2018/8/16
 */
@Component
public class LocalStoreOrderService {

    final static Logger logger = org.slf4j.LoggerFactory.getLogger(LocalStoreOrderService.class);

    @MotanReferer
    TrdSpOrderStatusApi trdSpOrderStatusApi;


    @MotanReferer
    OrderMainApi orderMainApi;

    @MotanReferer
    StoreOrderApi storeOrderApi;

    @Autowired
    SequenceUtil sequenceUtil;

    @MotanReferer
    SubOrderApi subOrderApi;

    @Autowired
    LocalStoreProductApi localStoreProductApi;

    public BaseResponse cancelOrder(LocalStoreOpeatorVo localStoreOpeatorVo) {
        if (Lang.isEmpty(localStoreOpeatorVo)) {
            logger.info("localStoreOpeatorVo:{}", JSON.toJSONString(localStoreOpeatorVo));
            return new BaseResponse("参数为空");
        }
        BaseResponse baseResponse = new BaseResponse();
        try {
            storeOrderApi.cancleOrder(localStoreOpeatorVo.getThirdOrderNo(), localStoreOpeatorVo.getStoreId(), localStoreOpeatorVo.getOrderId());
            localStoreProductApi.cancelOccupyStock(localStoreOpeatorVo.getThirdOrderNo(), localStoreOpeatorVo.getStoreId());
            baseResponse.setResultCode(MessageDictionary.RETURN_SUCCESS_CODE);
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage(MessageDictionary.RETURN_SUCCESS_MESSAGE);
        } catch (Exception e) {
            logger.error("取消订单异常", e);
        }
        return baseResponse;
    }


    public BaseResponse takeOrder(LocalStoreOrderVo localStoreOrderVo) {
        BaseResponse baseResponse = new BaseResponse();
        if (Lang.isEmpty(localStoreOrderVo)) {
            logger.info("localStoreOrderVo:{}", JSON.toJSONString(localStoreOrderVo));
            return new BaseResponse("参数为空");
        }
        try {
            OrderMainDto orderMainDto = orderMainApi.findByOrderNo(localStoreOrderVo.getOrderNo());
            //TODO 测试数据不用考虑去重 测试完成改回来 有第三方账号加不为空
            if (!Lang.isEmpty(orderMainDto.getThirdOrderNo())) {
                logger.info("orderMainDto:{}", JSON.toJSONString(orderMainDto));
                baseResponse.setResultCode(MessageDictionary.RETURN_ERROR_CODE);
                baseResponse.setSuccess(false);
                baseResponse.setResultMessage("请不要重复下单");
                return baseResponse;
            } else {

                String ThirdOrderNo = sequenceUtil.getOrderNo("LocalThirdOrderNo");
                localStoreOrderVo.setOrderNo(orderMainDto.getOrderNo());
                baseResponse = localStoreProductApi.occupyStock(localStoreOrderVo);
                storeOrderApi.takeOrder(localStoreOrderVo.getOrderNo(), localStoreOrderVo.getStoreId());
                orderMainDto.setThirdOrderNo(ThirdOrderNo);
                boolean falg = orderMainApi.updateThirdNo(localStoreOrderVo.getOrderNo(), ThirdOrderNo);
                if (falg) {
                    logger.info("更新第三方订单号成功");
                }
                storeOrderApi.addSubOrder(localStoreOrderVo.getOrderNo());

            }
        } catch (Exception e) {
            logger.error("预占库存异常", e);
        }
        return baseResponse;
    }


    public BaseResponse confirmOrder(LocalStoreOpeatorVo localStoreOpeatorVo) {
        BaseResponse baseResponse = new BaseResponse();
        if (Lang.isEmpty(localStoreOpeatorVo)) {
            logger.info("localStoreOpeatorVo:{}", JSON.toJSONString(localStoreOpeatorVo));
            return new BaseResponse("参数为空");
        }
        try {
            storeOrderApi.confimOrder(localStoreOpeatorVo.getThirdOrderNo(), localStoreOpeatorVo.getStoreId(), localStoreOpeatorVo.getOrderId());
        } catch (Exception e) {
            logger.error("确认订单异常", e);
        }
        return baseResponse;
    }

}


