package localstore.service.service;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import localstore.dto.LocalStoreOrderVo;
import localstore.dto.ProviderGoodsStockVo;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import pool.api.ProviderGoodsApi;
import pool.commonUtil.MessageDictionary;
import pool.dto.ProviderGoodsStock;
import sinomall.global.common.response.BaseResponse;
import store.api.MallShippingApi;
import store.api.dto.mapdto.MallShippingDto;
import utils.Lang;
import utils.collection.CollectionUtil;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 张代春
 * @date 2018/8/16
 */
@Component
public class LocalStoreProductService {
    final static Logger logger = org.slf4j.LoggerFactory.getLogger(LocalStoreProductService.class);

    @MotanReferer
    ProviderGoodsApi providerGoodsApi;

    @MotanReferer
    OrderMainApi orderMainApi;

    @MotanReferer
    MallShippingApi mallShippingApi;


    public BaseResponse findOrderStatus(String orderNo) {
        if(Lang.isEmpty(orderNo)){
            return new BaseResponse("订单号为空");
        }
        String statusByOrderNo = orderMainApi.findStatusByOrderNo(orderNo);
        if(Lang.isEmpty(statusByOrderNo)){
            return new BaseResponse("订单状态查询失败");
        }
        return new BaseResponse<>(true,"订单状态查询成功",statusByOrderNo);
    }

    public BaseResponse queryGoods(List<String> skus, String storeId){
        if(CollectionUtil.isEmpty(skus) || Lang.isEmpty(storeId)){
            logger.info("skus:{},storeId:{}", JSON.toJSONString(skus),storeId);
            return new BaseResponse("参数为空");
        }
        BaseResponse baseResponse=providerGoodsApi.queryGoods(skus,storeId);
       return baseResponse;
    }

    public BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo){
        if(Lang.isEmpty(localStoreOrderVo)){
            logger.info("localStoreOrderVo:{}", JSON.toJSONString(localStoreOrderVo));
            return new BaseResponse("参数为空");
        }
        BaseResponse baseResponse=providerGoodsApi.occupyStock(localStoreOrderVo);
        return baseResponse;
    }

    public BaseResponse cancelOccupyStock(String thrOrderNo, String storedId) {
        if(Lang.isEmpty(thrOrderNo) || Lang.isEmpty(storedId)){
            logger.info("thrOrderNo:{},storeId:{}", thrOrderNo,storedId);
            return new BaseResponse("参数为空");
        }
        try{
            BaseResponse baseResponse = providerGoodsApi.cancelOccupyStock(thrOrderNo, storedId);
            if(baseResponse.isSuccess()){
                return new BaseResponse(true,"预占库存取消成功");
            }
        }catch(Exception e){
            logger.error("创建订单异常{}", e);
        }
        return new BaseResponse("预占库存取消失败");
    }




    public BaseResponse confirmOrder(String orderNo){
        BaseResponse baseResponse=new BaseResponse();
        if(Lang.isEmpty(orderNo)){
            logger.info("orderNo:{},", JSON.toJSONString(orderNo));
            return new BaseResponse("参数为空");
        }
        baseResponse.setResultMessage("确认下单成功");
        baseResponse.setResultCode("0000");
        baseResponse.setSuccess(true);
        baseResponse.setResult("");
        return baseResponse;
    }

    /**
     * @author junyang.dong
     * @param thirdOrderNo 第三方订单号
     * @return
     */
    public List<MallShippingDto> findOrderLogistics(String thirdOrderNo) {
        return mallShippingApi.queryMallShippingByOrderNo(thirdOrderNo);
    }
}
