package localstore.service.service;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import localstore.dto.LocalStoreOrderVo;
import localstore.dto.ProviderGoodsStockVo;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import pool.api.ProviderGoodsApi;
import pool.dto.ProviderGoodsStock;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.collection.CollectionUtil;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 张代春
 * @date 2018/8/16
 */
@Component
public class LocalStoreService{
    final static Logger logger = org.slf4j.LoggerFactory.getLogger(LocalStoreService.class);

    @MotanReferer
    ProviderGoodsApi providerGoodsApi;

    @MotanReferer
    OrderMainApi orderMainApi;

    public BaseResponse findOrderStatus(String orderNo,String storeId) {
        if(Lang.isEmpty(orderNo)){
            return new BaseResponse("订单号为空");
        }
        OrderMainDto status = orderMainApi.findByOrderNoAndProviderId(orderNo, storeId);
        if(Lang.isEmpty(status)&&Lang.isEmpty(status.getTrdSpStatus())){
            return new BaseResponse("订单状态查询失败");
        }
        return new BaseResponse(true,"订单状态查询成功",status);
    }

    //TODO 修改判斷list為空或者null
    public BaseResponse queryGoods(List<String> skus, String storeId){
        if(CollectionUtil.isEmpty(skus) || Lang.isEmpty(storeId)){
            logger.info("skus:{},storeId:{}", JSON.toJSONString(skus),storeId);
            return new BaseResponse("参数为空");
        }
        BaseResponse baseResponse=providerGoodsApi.queryGoods(skus,storeId);
       return baseResponse;
    }

    public BaseResponse occupyStock(String sku, String storeId,Integer count){
        if(Lang.isEmpty(sku) || Lang.isEmpty(storeId) || count==0){
            logger.info("sku:{},storeId:{},count:{}", JSON.toJSONString(sku),storeId,count);
            return new BaseResponse("参数为空");
        }
        LocalStoreOrderVo localStoreOrderVo = new LocalStoreOrderVo();
        localStoreOrderVo.setStoreId(storeId);
        localStoreOrderVo.setList(new ArrayList<>());
        ProviderGoodsStockVo p = new ProviderGoodsStockVo();
        p.setSku(sku);
        p.setStockCount(count);
        localStoreOrderVo.getList().add(p);
        BaseResponse baseResponse=providerGoodsApi.occupyStock(localStoreOrderVo);
        return baseResponse;
    }

    //todo 確定預佔庫存
    public BaseResponse confirmOrder(String orderNo){
        BaseResponse baseResponse=new BaseResponse();
        logger.info("确认预占库存，orderNo:{},", JSON.toJSONString(orderNo));
        if(Lang.isEmpty(orderNo)){
            logger.info("orderNo:{},", JSON.toJSONString(orderNo));
            return new BaseResponse("参数为空");
        }
        baseResponse.setResultMessage("确认下单成功");
        baseResponse.setResultCode("0000");
        baseResponse.setSuccess(true);
        baseResponse.setResult("");
        return baseResponse;
    }
}
