/*
 * Decompiled with CFR 0.152.
 */
package localstore.service.service;

import cart.api.OrderMainApi;
import cart.api.SubOrderApi;
import cart.api.TrdSpOrderStatusApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import localstore.api.LocalStoreProductApi;
import localstore.dto.LocalStoreOpeatorVo;
import localstore.dto.LocalStoreOrderVo;
import localstore.service.utils.SequenceUtil;
import order.api.StoreOrderApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Component
public class LocalStoreOrderService {
    static final Logger logger = LoggerFactory.getLogger(LocalStoreOrderService.class);
    @MotanReferer
    TrdSpOrderStatusApi trdSpOrderStatusApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    StoreOrderApi storeOrderApi;
    @Autowired
    SequenceUtil sequenceUtil;
    @MotanReferer
    SubOrderApi subOrderApi;
    @Autowired
    LocalStoreProductApi localStoreProductApi;

    public BaseResponse cancelOrder(LocalStoreOpeatorVo localStoreOpeatorVo) {
        if (Lang.isEmpty((Object)localStoreOpeatorVo)) {
            logger.info("localStoreOpeatorVo:{}", (Object)JSON.toJSONString((Object)localStoreOpeatorVo));
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        BaseResponse baseResponse = new BaseResponse();
        try {
            this.storeOrderApi.cancleOrder(localStoreOpeatorVo.getThirdOrderNo(), localStoreOpeatorVo.getStoreId(), localStoreOpeatorVo.getOrderId());
            this.localStoreProductApi.cancelOccupyStock(localStoreOpeatorVo.getThirdOrderNo(), localStoreOpeatorVo.getStoreId());
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
        }
        return baseResponse;
    }

    public BaseResponse takeOrder(LocalStoreOrderVo localStoreOrderVo) {
        BaseResponse baseResponse = new BaseResponse();
        if (Lang.isEmpty((Object)localStoreOrderVo)) {
            logger.info("localStoreOrderVo:{}", (Object)JSON.toJSONString((Object)localStoreOrderVo));
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            OrderMainDto orderMainDto = this.orderMainApi.findByOrderNo(localStoreOrderVo.getOrderNo());
            if (!Lang.isEmpty((Object)orderMainDto.getThirdOrderNo())) {
                logger.info("orderMainDto:{}", (Object)JSON.toJSONString((Object)orderMainDto));
                baseResponse.setResultCode("0404");
                baseResponse.setSuccess(false);
                baseResponse.setResultMessage("\u8bf7\u4e0d\u8981\u91cd\u590d\u4e0b\u5355");
                return baseResponse;
            }
            String ThirdOrderNo = this.sequenceUtil.getOrderNo("LocalThirdOrderNo");
            localStoreOrderVo.setOrderNo(orderMainDto.getOrderNo());
            baseResponse = this.localStoreProductApi.occupyStock(localStoreOrderVo);
            this.storeOrderApi.takeOrder(localStoreOrderVo.getOrderNo(), localStoreOrderVo.getStoreId());
            orderMainDto.setThirdOrderNo(ThirdOrderNo);
            boolean falg = this.orderMainApi.updateThirdNo(localStoreOrderVo.getOrderNo(), ThirdOrderNo);
            if (falg) {
                logger.info("\u66f4\u65b0\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7\u6210\u529f");
            }
            this.storeOrderApi.addSubOrder(localStoreOrderVo.getOrderNo());
        }
        catch (Exception e) {
            logger.error("\u9884\u5360\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
        }
        return baseResponse;
    }

    public BaseResponse confirmOrder(LocalStoreOpeatorVo localStoreOpeatorVo) {
        BaseResponse baseResponse = new BaseResponse();
        if (Lang.isEmpty((Object)localStoreOpeatorVo)) {
            logger.info("localStoreOpeatorVo:{}", (Object)JSON.toJSONString((Object)localStoreOpeatorVo));
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.storeOrderApi.confimOrder(localStoreOpeatorVo.getThirdOrderNo(), localStoreOpeatorVo.getStoreId(), localStoreOpeatorVo.getOrderId());
        }
        catch (Exception e) {
            logger.error("\u786e\u8ba4\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
        }
        return baseResponse;
    }
}

