/*
 * Decompiled with CFR 0.152.
 */
package localstore.service.service;

import cart.api.OrderMainApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.List;
import localstore.dto.LocalStoreOrderVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pool.api.ProviderGoodsApi;
import sinomall.global.common.response.BaseResponse;
import store.api.MallShippingApi;
import store.api.dto.mapdto.MallShippingDto;
import utils.Lang;
import utils.collection.CollectionUtil;

@Component
public class LocalStoreProductService {
    static final Logger logger = LoggerFactory.getLogger(LocalStoreProductService.class);
    @MotanReferer
    ProviderGoodsApi providerGoodsApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    MallShippingApi mallShippingApi;

    public BaseResponse findOrderStatus(String orderNo) {
        if (Lang.isEmpty((Object)orderNo)) {
            return new BaseResponse("\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        String statusByOrderNo = this.orderMainApi.findStatusByOrderNo(orderNo);
        if (Lang.isEmpty((Object)statusByOrderNo)) {
            return new BaseResponse("\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u5931\u8d25");
        }
        return new BaseResponse(true, "\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u6210\u529f", (Object)statusByOrderNo);
    }

    public BaseResponse queryGoods(List<String> skus, String storeId) {
        if (CollectionUtil.isEmpty(skus) || Lang.isEmpty((Object)storeId)) {
            logger.info("skus:{},storeId:{}", (Object)JSON.toJSONString(skus), (Object)storeId);
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        BaseResponse baseResponse = this.providerGoodsApi.queryGoods(skus, storeId);
        return baseResponse;
    }

    public BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo) {
        if (Lang.isEmpty((Object)localStoreOrderVo)) {
            logger.info("localStoreOrderVo:{}", (Object)JSON.toJSONString((Object)localStoreOrderVo));
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        BaseResponse baseResponse = this.providerGoodsApi.occupyStock(localStoreOrderVo);
        return baseResponse;
    }

    public BaseResponse cancelOccupyStock(String thrOrderNo, String storedId) {
        if (Lang.isEmpty((Object)thrOrderNo) || Lang.isEmpty((Object)storedId)) {
            logger.info("thrOrderNo:{},storeId:{}", (Object)thrOrderNo, (Object)storedId);
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            BaseResponse baseResponse = this.providerGoodsApi.cancelOccupyStock(thrOrderNo, storedId);
            if (baseResponse.isSuccess()) {
                return new BaseResponse(true, "\u9884\u5360\u5e93\u5b58\u53d6\u6d88\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5f02\u5e38{}", (Throwable)e);
        }
        return new BaseResponse("\u9884\u5360\u5e93\u5b58\u53d6\u6d88\u5931\u8d25");
    }

    public BaseResponse confirmOrder(String orderNo) {
        BaseResponse baseResponse = new BaseResponse();
        if (Lang.isEmpty((Object)orderNo)) {
            logger.info("orderNo:{},", (Object)JSON.toJSONString((Object)orderNo));
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        baseResponse.setResultMessage("\u786e\u8ba4\u4e0b\u5355\u6210\u529f");
        baseResponse.setResultCode("0000");
        baseResponse.setSuccess(true);
        baseResponse.setResult((Object)"");
        return baseResponse;
    }

    public List<MallShippingDto> findOrderLogistics(String thirdOrderNo) {
        return this.mallShippingApi.queryMallShippingByOrderNo(thirdOrderNo);
    }
}

