/*
 * Decompiled with CFR 0.152.
 */
package localstore.service.service;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.List;
import localstore.dto.LocalStoreOrderVo;
import localstore.dto.ProviderGoodsStockVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pool.api.ProviderGoodsApi;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.collection.CollectionUtil;

@Component
public class LocalStoreService {
    static final Logger logger = LoggerFactory.getLogger(LocalStoreService.class);
    @MotanReferer
    ProviderGoodsApi providerGoodsApi;
    @MotanReferer
    OrderMainApi orderMainApi;

    public BaseResponse findOrderStatus(String orderNo, String storeId) {
        if (Lang.isEmpty((Object)orderNo)) {
            return new BaseResponse("\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        OrderMainDto status = this.orderMainApi.findByOrderNoAndProviderId(orderNo, storeId);
        if (Lang.isEmpty((Object)status) && Lang.isEmpty((Object)status.getTrdSpStatus())) {
            return new BaseResponse("\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u5931\u8d25");
        }
        return new BaseResponse(true, "\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u6210\u529f", (Object)status);
    }

    public BaseResponse queryGoods(List<String> skus, String storeId) {
        if (CollectionUtil.isEmpty(skus) || Lang.isEmpty((Object)storeId)) {
            logger.info("skus:{},storeId:{}", (Object)JSON.toJSONString(skus), (Object)storeId);
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        BaseResponse baseResponse = this.providerGoodsApi.queryGoods(skus, storeId);
        return baseResponse;
    }

    public BaseResponse occupyStock(String sku, String storeId, Integer count) {
        if (Lang.isEmpty((Object)sku) || Lang.isEmpty((Object)storeId) || count == 0) {
            logger.info("sku:{},storeId:{},count:{}", new Object[]{JSON.toJSONString((Object)sku), storeId, count});
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        LocalStoreOrderVo localStoreOrderVo = new LocalStoreOrderVo();
        localStoreOrderVo.setStoreId(storeId);
        localStoreOrderVo.setList(new ArrayList());
        ProviderGoodsStockVo p = new ProviderGoodsStockVo();
        p.setSku(sku);
        p.setStockCount(count);
        localStoreOrderVo.getList().add(p);
        BaseResponse baseResponse = this.providerGoodsApi.occupyStock(localStoreOrderVo);
        return baseResponse;
    }

    public BaseResponse confirmOrder(String orderNo) {
        BaseResponse baseResponse = new BaseResponse();
        logger.info("\u786e\u8ba4\u9884\u5360\u5e93\u5b58\uff0corderNo:{},", (Object)JSON.toJSONString((Object)orderNo));
        if (Lang.isEmpty((Object)orderNo)) {
            logger.info("orderNo:{},", (Object)JSON.toJSONString((Object)orderNo));
            return new BaseResponse("\u53c2\u6570\u4e3a\u7a7a");
        }
        baseResponse.setResultMessage("\u786e\u8ba4\u4e0b\u5355\u6210\u529f");
        baseResponse.setResultCode("0000");
        baseResponse.setSuccess(true);
        baseResponse.setResult((Object)"");
        return baseResponse;
    }
}

