/*
 * Decompiled with CFR 0.152.
 */
package localstore.service.utils;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import redis.clients.jedis.exceptions.JedisDataException;
import utils.collection.CollectionUtil;

public class SequenceUtil
implements InitializingBean,
DisposableBean {
    private final String ORDERNO_REDIS_KEY = "mall:orderNo";
    private final String CREATE_SEQUECENCE_TABLE_SQL = "create table   mall_sequence_table(sequenceKey varchar(255) ,sequence number)";
    private final String INIT_SEQUECENCE_TABLE_SQL = "insert into mall_sequence_table  (sequenceKey,sequence) values(?,?)";
    private final String QUERY_SEQUECENCE_TABLE_SQL = "select sequence from  mall_sequence_table where sequenceKey=? ";
    private final String QUERY_MAX_SEQUECENCE_TABLE_SQL = "select max(sequence) from  mall_sequence_table where sequenceKey=? ";
    private final String QUERY_GROUP_SEQUECENCE_TABLE_SQL = "select sequenceKey  from  mall_sequence_table group by sequenceKey having count(*)>1";
    private final String UPDATE_SEQUECENCE_TABLE_SQL = "update  mall_sequence_table  set sequence=? where (sequence<? or sequence>=?) and sequenceKey=?";
    private final String DELETE_SEQUECENCE_TABLE_SQL = "delete from mall_sequence_table where sequenceKey=?";
    private final String DROP_SEQUECENCE_TABLE_SQL = "drop table mall_sequence_table";
    private Logger logger;
    ExecutorService executorService;
    RedisTemplate redisTemplate;
    JdbcTemplate jdbcTemplate;
    public Long maxCycle;

    public SequenceUtil(RedisTemplate redisTemplate, JdbcTemplate jdbcTemplate) {
        List overSequences;
        block5: {
            this.ORDERNO_REDIS_KEY = "mall:orderNo";
            this.CREATE_SEQUECENCE_TABLE_SQL = "create table   mall_sequence_table(sequenceKey varchar(255) ,sequence number)";
            this.INIT_SEQUECENCE_TABLE_SQL = "insert into mall_sequence_table  (sequenceKey,sequence) values(?,?)";
            this.QUERY_SEQUECENCE_TABLE_SQL = "select sequence from  mall_sequence_table where sequenceKey=? ";
            this.QUERY_MAX_SEQUECENCE_TABLE_SQL = "select max(sequence) from  mall_sequence_table where sequenceKey=? ";
            this.QUERY_GROUP_SEQUECENCE_TABLE_SQL = "select sequenceKey  from  mall_sequence_table group by sequenceKey having count(*)>1";
            this.UPDATE_SEQUECENCE_TABLE_SQL = "update  mall_sequence_table  set sequence=? where (sequence<? or sequence>=?) and sequenceKey=?";
            this.DELETE_SEQUECENCE_TABLE_SQL = "delete from mall_sequence_table where sequenceKey=?";
            this.DROP_SEQUECENCE_TABLE_SQL = "drop table mall_sequence_table";
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.executorService = null;
            this.maxCycle = 1000000L;
            this.redisTemplate = redisTemplate;
            this.jdbcTemplate = jdbcTemplate;
            overSequences = null;
            try {
                overSequences = jdbcTemplate.queryForList("select sequenceKey  from  mall_sequence_table group by sequenceKey having count(*)>1", String.class);
            }
            catch (Exception e) {
                if (!(e instanceof BadSqlGrammarException)) break block5;
                try {
                    jdbcTemplate.execute("drop table mall_sequence_table");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jdbcTemplate.execute("create table   mall_sequence_table(sequenceKey varchar(255) ,sequence number)");
            }
        }
        if (CollectionUtil.isNoneEmpty((Collection)overSequences)) {
            overSequences.forEach(sequenceKey -> {
                Long maxSequence = (Long)jdbcTemplate.queryForObject("select max(sequence) from  mall_sequence_table where sequenceKey=? ", Long.class, new Object[]{sequenceKey});
                jdbcTemplate.update("delete from mall_sequence_table where sequenceKey=?", new Object[]{sequenceKey});
                jdbcTemplate.update("insert into mall_sequence_table  (sequenceKey,sequence) values(?,?)", new Object[]{sequenceKey, maxSequence});
            });
        }
    }

    public String getOrderNo(String sequenceKey) throws InterruptedException {
        int t;
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("mall:orderNo:" + sequenceKey));
        if (boundValueOperations.get() == null) {
            BoundValueOperations sequenceTableLockOperations = this.redisTemplate.boundValueOps((Object)("mall:orderNo:TABLE:LOCK:" + sequenceKey));
            if (!sequenceTableLockOperations.setIfAbsent((Object)true).booleanValue()) {
                Thread.sleep(300L);
                sequenceTableLockOperations.expire(10L, TimeUnit.SECONDS);
                return this.getOrderNo(sequenceKey);
            }
            SqlRowSet existSequenceRowSet = this.jdbcTemplate.queryForRowSet("select sequence from  mall_sequence_table where sequenceKey=? ", new Object[]{sequenceKey});
            Long existSequence = 0L;
            if (existSequenceRowSet.next()) {
                existSequence = existSequenceRowSet.getLong(1);
            }
            boundValueOperations.set((Object)existSequence);
        }
        long start = System.currentTimeMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("YYYYMMddHH");
        String dateTime = dateFormat.format(new Date());
        String sequence = null;
        Exception exception = null;
        for (t = 0; t < 5; ++t) {
            try {
                Long increment = boundValueOperations.increment(1L);
                if (increment >= this.maxCycle) {
                    BoundValueOperations sequenceLockOperations = this.redisTemplate.boundValueOps((Object)("mall:orderNo:CIRCULATE:LOCK:" + sequenceKey));
                    if (sequenceLockOperations.setIfAbsent((Object)true).booleanValue()) {
                        boundValueOperations.set((Object)0L);
                        sequenceLockOperations.expire(300L, TimeUnit.MICROSECONDS);
                        return this.getOrderNo(sequenceKey);
                    }
                    Thread.sleep(200L);
                    return this.getOrderNo(sequenceKey);
                }
                sequence = dateTime + String.valueOf(increment + this.maxCycle).substring(1);
                this.executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            catch (Exception e) {
                if (e instanceof JedisDataException) {
                    boundValueOperations.set((Object)0L);
                }
                exception = e;
                Thread.sleep(100L);
                continue;
            }
        }
        if (t >= 5) {
            throw new RuntimeException("\u751f\u6210\u5e8f\u5217\u53f7\u5931\u8d25", exception);
        }
        this.logger.debug("\u751f\u6210\u5e8f\u5217\u53f7\u8017\u65f6\uff1a{} ", (Object)(System.currentTimeMillis() - start));
        return sequence;
    }

    private void updateSequence(Long increment, String sequenceKey) {
        this.jdbcTemplate.update("update  mall_sequence_table  set sequence=? where (sequence<? or sequence>=?) and sequenceKey=?", new Object[]{increment, increment, this.maxCycle - 1L, sequenceKey});
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService = new ThreadPoolExecutor(3, 6, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(200000));
    }

    static /* synthetic */ void access$000(SequenceUtil x0, Long x1, String x2) {
        x0.updateSequence(x1, x2);
    }
}

