package m.coupon.api;

import m.coupon.api.response.McouponResponse;

import java.util.Map;

/**
 * Created by Roney on 2017-09-25.
 */
public interface McouponApi {
    /**
     * 获取优惠券列表
     * （一期不做）
     *
     * @param param
     * @return
     */
    public Map<String, String> getMcouponList(Map<String, String> param);

    /***
     * 获取优惠券激活码（目前支持一个获取）
     * 多个获取需要调用方进行遍历，多次调用。目前优惠券不支持多个获取
     *
     * @param param  由于优惠券参数是动态变化的，因此，调用方需要自己拼装参数
     *               就目前的使用需要以下两个参数即可
     *                params.put("typeId",typeId);
     *                 params.put("count",count);
     *               注意：通过和M劵沟通，现在count只能写1，一次只能请求一个
     * @return map 结果如下：
     *  errcode: "0",  0成功，其他的都是失败，20000表示请求参数有误 具体见msg
     *     msg: "成功",
     *  validStart: "20170726",开始时间
     * validEnd: "20171231",结束日期
     *  exchangeNo: "21a55c84" 激活码
     *
     */
    public Map<String, String> exchangeCode(Map<String, String> param);

}
