package m.coupon.model;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import utils.sql.BaseDomain;

import javax.persistence.*;

/**
 * Created by Roney on 2017-09-20.
 * M劵日志信息
 */
@Entity
@Table(name = "OUT_COUPON_LOGS")
public class CouponLogs extends BaseDomain {
    @Transient
    @JSONField(serialize=false, deserialize = false)
    public static final String LOG_TYPE_ERROR = "ERROR"; // 错误日志
    @Transient
    @JSONField(serialize=false, deserialize = false)
    public static final String LOG_TYPE_INFO = "INFO"; // 信息日志
    @Transient
    @JSONField(serialize=false, deserialize = false)
    public static final String LOG_TYPE_DEBUG = "DEBUG"; // 调试日志，可用于输出详细信息，以便查找日志时与INFO区分
    @Transient
    @JSONField(serialize=false, deserialize = false)
    public static final String LOG_TYPE_WARNNING = "WARNING"; // 告警日志
    @Transient
    @JSONField(serialize=false, deserialize = false)
    public static final String LOG_TYPE_EXECUTION = "EXECUTION"; // 执行日志

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String id; // 主键


    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名
     */
    private String userName;

    /**
     * ip地址
     */
    private String ip;

    /**
     * 请求url
     */
    private String postUrl;

    /**
     * 日志来源
     */

    private String logSource;

    /**
     * 类型
     */
    private String logType;

    /**
     * 请求信息
     */
    @Column(name = "post_desc", columnDefinition = "clob")
    @Type(type = "text")
    private String postDesc;

    /**
     * 返回信息
     */
    @Column(name = "return_desc", columnDefinition = "clob")
    @Type(type = "text")
    private String returnDesc;

    /**
     * 错误信息
     */
    @Column(name = "error_desc", columnDefinition = "clob")
    @Type(type = "text")
    private String errorDesc;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPostUrl() {
        return postUrl;
    }

    public void setPostUrl(String postUrl) {
        this.postUrl = postUrl;
    }

    public String getLogSource() {
        return logSource;
    }

    public void setLogSource(String logSource) {
        this.logSource = logSource;
    }

    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getPostDesc() {
        return postDesc;
    }

    public void setPostDesc(String postDesc) {
        this.postDesc = postDesc;
    }

    public String getReturnDesc() {
        return returnDesc;
    }

    public void setReturnDesc(String returnDesc) {
        this.returnDesc = returnDesc;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CouponLogs that = (CouponLogs) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
