package m.coupon.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import m.coupon.api.McouponApi;
import m.coupon.api.response.McouponResponse;
import m.coupon.model.CouponLogs;
import m.coupon.service.entity.AccountEntity;
import m.coupon.service.service.CouponLogsService;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import utils.Lang;
import utils.convert.converters.map.ObjectToMapConverter;
import utils.security.MD5Utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by Roney on 2017-09-25.
 */
@MotanService
public class McouponApiImpl implements McouponApi{
    public static final Logger logger = LoggerFactory.getLogger(McouponApiImpl.class);

    @Autowired
    private AccountEntity accountEntity;

    @Autowired
    CouponLogsService couponLogsService;

    @Override
    public  Map<String, String> getMcouponList(Map<String, String> param) {
        String absUrl="/couponsys/api/buyer/exchangeCode/couponType/list?";
        String postUrl=gennerUrl(absUrl,null);
        logger.info("Sending request {} ", postUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(postUrl);
        CloseableHttpResponse response = null;
        Map<String, String> returnData = new HashMap<>();
        try {
            response = httpclient.execute(httpGet);
            logger.info(response.getStatusLine()+"");
            if(response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String contentJson = EntityUtils.toString(entity);
                returnData=contentMap(contentJson,postUrl);
            }
        } catch (ClientProtocolException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();

        } finally {
            if(response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return returnData;
    }

    @Override
    public Map<String, String> exchangeCode(Map<String, String> param) {
        String absUrl="/couponsys/api/buyer/exchangeCode/send?";
        String postUrl=gennerUrl(absUrl,param);
        logger.info("Sending request {} ", postUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(postUrl);
        CloseableHttpResponse response = null;
        Map<String, String> returnData = new HashMap<>();
        try {
            response = httpclient.execute(httpGet);
            logger.info(response.getStatusLine()+"");
            if(response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();

                String contentJson = EntityUtils.toString(entity);

                returnData=contentMap(contentJson,postUrl);


            }
        } catch (ClientProtocolException e) {
            e.printStackTrace();
            returnData.put("error",Lang.toString(e));
        } catch (IOException e) {
            e.printStackTrace();
            returnData.put("error",Lang.toString(e));
        } finally {
            if(response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return returnData;
    }

    private String gennerUrl(String url,Map<String ,String> map){
        String account=accountEntity.getAccount();
        String baseUrl=accountEntity.getBaseUrl();
        String signBaseUrl=baseUrl;
       if(baseUrl.indexOf("9999")>0){
            signBaseUrl=baseUrl.replace(":9999","");
       }

        String version=accountEntity.getVersion();
        String signUrl=signBaseUrl+url;//"http://demo.micvs.com"+"/couponsys/api/buyer/exchangeCode/couponType/list?";
        String noSignUrl=baseUrl+url;
        Long timestamp=new Date().getTime();
        Map<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("account",account);
        treeMap.put("timestamp",timestamp);
        treeMap.put("version",version);
        if(!Lang.isEmpty(map)){
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key=entry.getKey();
                String value=entry.getValue();
                treeMap.put(key,value);
                logger.info("key= " + key + " and value= " +value);

            }

        }

        String urlParams=sortParams(treeMap);

        String signUrlParams=signUrl+urlParams;
        String sig= MD5Utils.MD5Encode(signUrlParams, "utf-8");
        String returnSignUrl=noSignUrl+urlParams;
        String returnUrl=returnSignUrl+"&sig="+sig;
        return returnUrl;
    }

    public String sortParams( Map<String, Object> treeMap ){
        StringBuilder sb=new StringBuilder();
        for (Map.Entry<String, Object> entry : treeMap.entrySet()) {
            String key=entry.getKey();
            Object value= (Object) entry.getValue();
            sb.append("&"+key+"="+value);
            logger.info("key= " + key + " and value= " +value);

        }
        String returnStr=sb.toString();
        return returnStr.substring(1);

    }

    public Map contentMap(String contentJson,String postUrl){
        Map<String, Object> returnData = new HashMap<>();
        String returnCode="errcode";
        String errcodeValue="0";
        String msgKey="msg";
        returnData.put(returnCode,errcodeValue);//返回0表示成功，其他的都是失败
        logger.info(contentJson);
        CouponLogs couponLogs=new CouponLogs();
        couponLogs.setPostUrl(postUrl);
        couponLogs.setReturnDesc(contentJson);
        couponLogs.setLogType(CouponLogs.LOG_TYPE_INFO);
        couponLogsService.saveLog(couponLogs);
        //returnData.put("content", contentJson);
        try {
            JSONObject jsStr = JSONObject.parseObject(contentJson);
            if (!Lang.isEmpty(jsStr)) {
                if (!Lang.isEmpty(jsStr.get(returnCode)) && jsStr.get(returnCode).toString().equals(errcodeValue)) {
                    returnData.put(msgKey, jsStr.get(msgKey));
                    //returnData.put("list", jsStr.get("list"));
                    JSONArray codeArray = (JSONArray) jsStr.get("list");
                    JSONObject obj=codeArray.getJSONObject(0);
                    Set<String> set = obj.keySet();
                    Iterator<String> it = set.iterator();
                    while (it.hasNext()) {
                        String key = it.next();
                        // 根据key获得value, value也可以是JSONObject,JSONArray,使用对应的参数接收即可
                        Object value = obj.getString(key);
                        logger.info("key= " + key + " and value= " +value);
                        returnData.put(key,value);
                    }

                    //JSONArray jsStr.get("list")
                } else {
                    returnData.put(msgKey, jsStr.get(msgKey));
                    returnData.put(returnCode, jsStr.get(returnCode));
                }
            } else {
                returnData.put(msgKey, "接口返回信息失败");
                returnData.put(returnCode, 99);
            }
        }catch (Exception e){
            returnData.put(msgKey, "接口数据解析失败");
            returnData.put(returnCode, 99);
        }
        return returnData;
    }
}
