package m.coupon.service.controller;


import m.coupon.api.McouponApi;
import m.coupon.api.response.McouponResponse;
import m.coupon.model.CouponLogs;
import m.coupon.service.service.CouponLogsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import utils.log.Log;
import utils.log.Logs;
import utils.web.Webs;

import javax.persistence.criteria.CriteriaBuilder;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-09-20.
 */
@RestController
@RequestMapping("/coupon")
public class CouponController {
    private final static Log log = Logs.getLog(CouponController.class.getName());


    @Autowired
    CouponLogsService couponLogsService;

    @Autowired
    McouponApi mcouponApi;
    @RequestMapping("/testSaveLogs")
    public List<CouponLogs>  testSaveLogs(@RequestParam(name="urls[]") String[] urls,HttpServletRequest request) {
        List<CouponLogs> couponLogses = new ArrayList<>();
        for(String url:urls){
            CouponLogs couponLogs = new CouponLogs();
            couponLogs.setIp(Webs.getIp(request));
            couponLogses.add(couponLogsService.saveLog(couponLogs));
        }
        return couponLogses;
    }

    @RequestMapping("/findCouponLogs")
    public Page<CouponLogs> findCouponLogs(Pageable pageable) {
        Page<CouponLogs> couponLogsPage =couponLogsService.findCouponLogs(null,null,pageable);

        return couponLogsPage;
    }


    @RequestMapping("/getMcouponList")
    public Map getMcouponList() {

        Map map=mcouponApi.getMcouponList(null);
        return map;
    }


    @RequestMapping("/exchangeCode")
    public Map exchangeCode(@RequestParam String typeId, String count) {
        Map params=new HashMap();
        params.put("typeId",typeId);
        params.put("count",count);
        Map map=mcouponApi.exchangeCode(params);
        return map;
    }


}
