package m.coupon.service.hibernate;


import org.hibernate.event.spi.*;
import org.hibernate.persister.entity.EntityPersister;
import utils.log.Log;
import utils.log.Logs;

public class CacheEventListener implements PostUpdateEventListener ,  PostInsertEventListener,PostDeleteEventListener{

    private static final long serialVersionUID = 1L;

    private final static Log log = Logs.getLog(CacheEventListener.class.getName());

    @Override
    public void onPostDelete(PostDeleteEvent event) {

        log.info("delete:"+event.getEntity().getClass()+":"+event.getEntity());
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        log.info("insert:"+event.getEntity().getClass()+":"+event.getEntity());
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        log.info("update:"+event.getEntity().getClass()+":"+event.getEntity());
    }

    @Override
    public boolean requiresPostCommitHanding(EntityPersister event) {
        log.info("here-----------------");
        return false;
    }




}