package m.coupon.service.service;

import m.coupon.model.CouponLogs;
import m.coupon.model.repository.CouponLogsRepos;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Roney on 2017-09-20.
 */
@Component
@Transactional(readOnly = true)
public class CouponLogsService {

    /**
     * 保存日志
     * @param log
     */
    @Transactional(readOnly = false)
    public CouponLogs saveLog(CouponLogs log) {
        return couponLogsRepos.saveAndFlush(log);
    }
    /** Attributes ============== */

    /** Methods ============== */

    /**
     * 分页查询
     * @param createTimeStart 日志记录时间区间开始
     * @param createTimeEnd 日志记录时间区间结束
     * @param pageable 分页对象
     * @return 分页结果集
     */
    public Page<CouponLogs> findCouponLogs( Date createTimeStart, Date createTimeEnd, Pageable pageable) {
        return couponLogsRepos.findAll(new Specification<CouponLogs>() {
            @Override
            public Predicate toPredicate(Root<CouponLogs> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                List<Predicate> where = new ArrayList<>();

                if(createTimeStart != null) {
                    where.add(cb.greaterThanOrEqualTo(root.get("dateCreated"), createTimeStart));
                }

                if(createTimeEnd != null) {
                    where.add(cb.lessThan(root.get("dateCreated"), createTimeEnd));
                }

                return cb.and(where.toArray(new Predicate[0]));
            }
        }, pageable);
    }



    /** Dependent Components ============== */
    @Autowired
    CouponLogsRepos couponLogsRepos;
    /** Setter and getters ============== */
}
