/*
 * Decompiled with CFR 0.152.
 */
package m.coupon.service.apiImpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import m.coupon.api.McouponApi;
import m.coupon.model.CouponLogs;
import m.coupon.service.entity.AccountEntity;
import m.coupon.service.service.CouponLogsService;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import utils.Lang;
import utils.security.MD5Utils;

@MotanService
public class McouponApiImpl
implements McouponApi {
    public static final Logger logger = LoggerFactory.getLogger(McouponApiImpl.class);
    @Autowired
    private AccountEntity accountEntity;
    @Autowired
    CouponLogsService couponLogsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getMcouponList(Map<String, String> param) {
        String absUrl = "/couponsys/api/buyer/exchangeCode/couponType/list?";
        String postUrl = this.gennerUrl(absUrl, null);
        logger.info("Sending request {} ", (Object)postUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(postUrl);
        CloseableHttpResponse response = null;
        Map<String, String> returnData = new HashMap<String, String>();
        try {
            response = httpclient.execute((HttpUriRequest)httpGet);
            logger.info(response.getStatusLine() + "");
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String contentJson = EntityUtils.toString((HttpEntity)entity);
                returnData = this.contentMap(contentJson, postUrl);
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> exchangeCode(Map<String, String> param) {
        String absUrl = "/couponsys/api/buyer/exchangeCode/send?";
        String postUrl = this.gennerUrl(absUrl, param);
        logger.info("Sending request {} ", (Object)postUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(postUrl);
        CloseableHttpResponse response = null;
        Map<String, String> returnData = new HashMap<String, String>();
        try {
            response = httpclient.execute((HttpUriRequest)httpGet);
            logger.info(response.getStatusLine() + "");
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String contentJson = EntityUtils.toString((HttpEntity)entity);
                returnData = this.contentMap(contentJson, postUrl);
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            returnData.put("error", Lang.toString((Object)((Object)e)));
        }
        catch (IOException e) {
            e.printStackTrace();
            returnData.put("error", Lang.toString((Object)e));
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return returnData;
    }

    private String gennerUrl(String url, Map<String, String> map) {
        String baseUrl;
        String account = this.accountEntity.getAccount();
        String signBaseUrl = baseUrl = this.accountEntity.getBaseUrl();
        if (baseUrl.indexOf("9999") > 0) {
            signBaseUrl = baseUrl.replace(":9999", "");
        }
        String version = this.accountEntity.getVersion();
        String signUrl = signBaseUrl + url;
        String noSignUrl = baseUrl + url;
        Long timestamp = new Date().getTime();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("account", account);
        treeMap.put("timestamp", timestamp);
        treeMap.put("version", version);
        if (!Lang.isEmpty(map)) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                treeMap.put(key, value);
                logger.info("key= " + key + " and value= " + value);
            }
        }
        String urlParams = this.sortParams(treeMap);
        String signUrlParams = signUrl + urlParams;
        String sig = MD5Utils.MD5Encode((String)signUrlParams, (String)"utf-8");
        String returnSignUrl = noSignUrl + urlParams;
        String returnUrl = returnSignUrl + "&sig=" + sig;
        return returnUrl;
    }

    public String sortParams(Map<String, Object> treeMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : treeMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sb.append("&" + key + "=" + value);
            logger.info("key= " + key + " and value= " + value);
        }
        String returnStr = sb.toString();
        return returnStr.substring(1);
    }

    public Map contentMap(String contentJson, String postUrl) {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        String returnCode = "errcode";
        String errcodeValue = "0";
        String msgKey = "msg";
        returnData.put(returnCode, errcodeValue);
        logger.info(contentJson);
        CouponLogs couponLogs = new CouponLogs();
        couponLogs.setPostUrl(postUrl);
        couponLogs.setReturnDesc(contentJson);
        couponLogs.setLogType("INFO");
        this.couponLogsService.saveLog(couponLogs);
        try {
            JSONObject jsStr = JSONObject.parseObject((String)contentJson);
            if (!Lang.isEmpty((Object)jsStr)) {
                if (!Lang.isEmpty((Object)jsStr.get((Object)returnCode)) && jsStr.get((Object)returnCode).toString().equals(errcodeValue)) {
                    returnData.put(msgKey, jsStr.get((Object)msgKey));
                    JSONArray codeArray = (JSONArray)jsStr.get((Object)"list");
                    JSONObject obj = codeArray.getJSONObject(0);
                    Set set = obj.keySet();
                    for (String key : set) {
                        String value = obj.getString(key);
                        logger.info("key= " + key + " and value= " + value);
                        returnData.put(key, value);
                    }
                } else {
                    returnData.put(msgKey, jsStr.get((Object)msgKey));
                    returnData.put(returnCode, jsStr.get((Object)returnCode));
                }
            } else {
                returnData.put(msgKey, "\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u5931\u8d25");
                returnData.put(returnCode, 99);
            }
        }
        catch (Exception e) {
            returnData.put(msgKey, "\u63a5\u53e3\u6570\u636e\u89e3\u6790\u5931\u8d25");
            returnData.put(returnCode, 99);
        }
        return returnData;
    }
}

