/*
 * Decompiled with CFR 0.152.
 */
package m.coupon.service.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import m.coupon.api.McouponApi;
import m.coupon.model.CouponLogs;
import m.coupon.service.service.CouponLogsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import utils.log.Log;
import utils.log.Logs;
import utils.web.Webs;

@RestController
@RequestMapping(value={"/coupon"})
public class CouponController {
    private static final Log log = Logs.getLog((String)CouponController.class.getName());
    @Autowired
    CouponLogsService couponLogsService;
    @Autowired
    McouponApi mcouponApi;

    @RequestMapping(value={"/testSaveLogs"})
    public List<CouponLogs> testSaveLogs(@RequestParam(name="urls[]") String[] urls, HttpServletRequest request) {
        ArrayList<CouponLogs> couponLogses = new ArrayList<CouponLogs>();
        for (String url : urls) {
            CouponLogs couponLogs = new CouponLogs();
            couponLogs.setIp(Webs.getIp((HttpServletRequest)request));
            couponLogses.add(this.couponLogsService.saveLog(couponLogs));
        }
        return couponLogses;
    }

    @RequestMapping(value={"/findCouponLogs"})
    public Page<CouponLogs> findCouponLogs(Pageable pageable) {
        Page couponLogsPage = this.couponLogsService.findCouponLogs(null, null, pageable);
        return couponLogsPage;
    }

    @RequestMapping(value={"/getMcouponList"})
    public Map getMcouponList() {
        Map map = this.mcouponApi.getMcouponList(null);
        return map;
    }

    @RequestMapping(value={"/exchangeCode"})
    public Map exchangeCode(@RequestParam String typeId, String count) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typeId", typeId);
        params.put("count", count);
        Map map = this.mcouponApi.exchangeCode(params);
        return map;
    }
}

