package outsideapi.api;

import outsideapi.vo.*;
import store.api.dto.modeldto.core.StoreDto;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 外部接口产品相关接口调用
 * Created by Liang Wenxu on 2016/11/24.
 */
public interface OutsideProductApi {

    /**
     * 爬虫触发节点类型：{@value} 手动触发
     */
    public static final String SPIDER_TRIGGER_TYPE_MANUAL = "MANUAL";
    /**
     * 爬虫触发节点类型：{@value} 订单触发
     */
    public static final String SPIDER_TRIGGER_TYPE_ORDER = "ORDER";
    /**
     * 爬虫触发节点类型：{@value} 商品详情触发
     */
    public static final String SPIDER_TRIGGER_TYPE_PD = "PD";

    /**
     * 供应商订单状态（统一）：{@value} 查询不到订单
     */
    String TRD_ORDER_NO_ORDER = "0";

    /**
     * 供应商订单状态（统一）：{@value} 正常，表示该供应商订单已正常预占库存并随时可进行确认下单
     */
    String TRD_ORDER_STATUS_NORMAL = "1";

    /**
     * 供应商订单状态（统一）：{@value} 已确认下单，表示供应商已确认下单，此时不能进行订单取消操作
     */
    String TRD_ORDER_STATUS_COMFIRMED = "2";

    /**
     * 供应商订单状态（统一）：{@value} 取消，标识该供应商订单已被取消，此时不能进行确认下单操作
     */
    String TRD_ORDER_STATUS_CANCELED = "3";

    /**
     * 获取第三方店铺商品实时库存
     * @param store
     * @param requetVo
     * @return HandlerRespVo<List<FashionStockStateVo>>
     *     错误代码errorCode定义： 1-- 请求参数错误 2-- 商户接口Handler未配置
     *     FashionStockStateVo 中的主要字段使用提醒：
     *          onSale： 标识是否可售状态，可能各个供应商其具体含义不同，当此值为false时商品应显示为不可售状态
     *          stockCount： 库存，当返回-1时为不限制库存（需结合onSale进行判断）
     *          isAreaRestrict： 当前地区是否限制购买，京东特有，其它供应商都将统一返回false，不对地区进行控制
     *          stockFlag：是否有货 0-- 无货，1--有货，2--预定（延后发货）
     */
    public HandlerRespVo<List<FashionStockStateVo>> getFashionStockState(StoreDto store, FashionStatusRequetVo requetVo);

    /**
     * 判断是否外部第三方店铺（实体类）
     * @param store 店铺信息实体类
     * @return HandlerRespVo.data返回true时为第三方商铺
     */
    public HandlerRespVo<Boolean> isOutsideStore(StoreDto store);

    /**
     * 判断是否外部第三方店铺
     * @param storeId Store店铺信息表ID
     * @return HandlerRespVo.data返回true时为第三方商铺
     */
    public HandlerRespVo<Boolean> isOutsideStore(String storeId);

    /**
     * 获取商品用于费率查询的区间基准值，京东为 协议价 / 市场价
     * @param requestVo 请求vo
     * @return 按requestVoList的索引顺序返回费率区间基准值
     *      <br>错误代码errorCode定义：
     *      <br>&nbsp;&nbsp;&nbsp;&nbsp;2 -- 商户接口Handler未配置
     *      <br>&nbsp;&nbsp;&nbsp;&nbsp;其它值 -- 其它错误
     *      <br>返回数据data: 用于费率查询的区间基准值
     */
    public HandlerRespVo<BigDecimal> getSalesPriceRateRangeVal(FashionPricesRequestVo requestVo);

    /**
     * 批量获取商品用于费率查询的区间基准值，京东为 协议价 / 市场价
     * @param requestVoList 请求VO列表（批量查询）
     * @return 按requestVoList的索引顺序返回费率区间基准值
     *      <br>错误代码errorCode定义：
     *      <br>&nbsp;&nbsp;&nbsp;&nbsp;2 -- 商户接口Handler未配置
     *      <br>&nbsp;&nbsp;&nbsp;&nbsp;其它值 -- 其它错误
     *      <br>返回数据data: 用于费率查询的区间基准值
     */
    public HandlerRespVo<List<BigDecimal>> getBatchSalesPriceRateRangeVal(List<FashionPricesRequestVo> requestVoList);

    /**
     * 查询第三方商户配送费用
     * @param storeId
     * @param requet
     * @return 成功时返回data为运费信息，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>&#9;2 -- 商户接口Handler未配置
     *      <br>&#9;其它代码 -- 其它错误
     *      </pre>
     *      <br>返回的data示意：
     *      <pre>data:{
     *      <br>&#9;freight: BigDecimal, // 总运费
     *      <br>&#9;baseFreight: BigDecimal, // 基础运费
     *      <br>&#9;remoteRegionFreight: BigDecimal, // 偏远运费
     *      <br>&#9;remoteFashions: String, // 需收取偏远运费的Fashion的id,多个ID使用","连接
     *      <br>}</pre>
     */
    public HandlerRespVo<Map<String, Object>> queryShippingFee(String storeId, ShippingFeeRequetVo requet);

    /**
     * 查询第三方实时价格接口
     * @param storeId 第三方商户Store的ID
     * @param request 请求参数Vo
     * @return 成功时返回data为运费信息，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>&#9;2 -- 商户接口Handler未配置
     *      <br>&#9;其它代码 -- 其它错误
     *      </pre>
     *      <br>返回的data为FashionPriceVo的集合
     */
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(String storeId, FashionPriceRequestVo request);

	/**
     * 查询第三方物流
     * @param orderNo 集采订单号
     * @return
     */
    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String orderNo);

    /**
     * 查询供应商订单状态
     * 返回的data为供应商订单状态状态值定义：
     *
     */
    public HandlerRespVo<String> orderStatus(String orderNo);

    /**
     * 获取第三方销售价格（放出一只小虫虫，直接爬单个商品的价格数据）
     * @param storeId 商户ID
     * @param request 商品价格请求参数
     * @param areaCode 集采地区代码，传最末级
     * @param async 异步方式开关，为true时异步执行，返回数据中将不包含抓取结果
     * @return 成功时返回data为运费信息，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>&#9;2 -- 商户接口Handler未配置
     *      <br>&#9;其它代码 -- 其它错误
     *      </pre>
     *      <br>返回的data为FashionPriceVo
     */
    public HandlerRespVo<BigDecimal> runPriceSpider(String storeId, FashionPriceParamVo request, String areaCode, String triggerType, Boolean async);

    /**
     * 获取第三方销售价格（爬虫方式，多个商品，预留）
     * @param storeId 商户ID
     * @param request 商品价格请求参数，fashionPriceParamVos传入需抓取的商品代码
     * @param request async 异步方式开关，为true时异步执行，返回数据中将不包含抓取结果
     * @return 成功时返回data为运费信息，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>&#9;2 -- 商户接口Handler未配置
     *      <br>&#9;其它代码 -- 其它错误
     *      </pre>
     *      <br>返回的data为List<SpiderLogs>，所有爬取成功的数据
     */
    public HandlerRespVo<Map<String, BigDecimal>> runPriceSpider(String storeId, FashionPriceRequestVo request, String triggerType, Boolean async);

    /**
     * 将集采通用地区编码集合转换为第三方地区编码集合
     * @param areaCodeMap 集采通用地区编码集合，key为层级，同AddressCommonApi.AddressLevel各层级的值，value为地区代码
     * @return 第三方接口约定地区编码集合，key为层级，同AddressCommonApi.AddressLevel各层级的值，value为地区代码
     */
    public HandlerRespVo<Map<Integer, String>> transAreaCodeMap(String storeId, Map<Integer, String> areaCodeMap);

    /**
     * 获取多个订单的物流可以是不同的供应商订单
     * @param orderNos
     * @return
     */
    public HandlerRespVo<List<OrderShippingPackageVo>> getManyOrderShipingTrace(List<String> orderNos);

    public String toString();

    /**
     * 将集采通用地区编码集合转换为第三方地区编码集合
     * @param requestVos 集采通用地区编码集合，key为层级，同AddressCommonApi.AddressLevel各层级的值，value为地区代码
     * @return 第三方接口约定地区编码集合，key为层级，同AddressCommonApi.AddressLevel各层级的值，value为地区代码
     */
    public HandlerRespVo<List<BatchAreaRequestVo>> batchTransAreaCodeMap(String storeKey,List<BatchAreaRequestVo> requestVos);

    /**
     * 生成预占单
     * @param reserveOrderVo
     * @param storeCode
     * @return 预订单ｉｄ对象
     */
    HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode);


    /**
     * 删除预占单　
     * @param reserveOrderIdVo
     * @param storeCode
     * @return true/false
     */
    HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode);

}
