package outsideapi.api;

import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.orderrequest.OrderRequst;

import java.util.List;

/**
 * 供应商订单API
 * @author Liang Wenxu
 * @since 2018/7/19
 */
public interface SupplierOrderApi {

    /**
     * 取消订单
     *
     *
     * @param trdOrderKey@return
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    Boolean cancelOrder(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException, OrderCancelException;

    /**
     * 向第三方供应商下单
     * @param orderMain 商城订单信息
     * @return 返回生产成功的第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口调用异常
     * @throws SupplierTakeOrderFalidException 供应商下单失败异常
     */
    TrdOrder takeOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierTakeOrderFalidException;

    /**
     * 确认下单，调用时记得处理所有的异常噢！
     * @param orderMain 商城订单信息
     * @throws SupplierInterfaceInvokeException 供应商接口调用异常
     * @throws SupplierOrderComfirmFalidException 供应商下单失败异常，其中错误代码3103表示已确认下单无需重复确认
     */
    void confirmOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException;

    /**
     * 订单退货（暂定）
     * @param orderMain 退货的订单信息
     * @param skuIds 退货的sku
     * @return
     * @throws SupplierInterfaceInvokeException
     */
    //TODO: 退货流程如何定义？可以允许怎样的退货（买多个sku退其中一个）等问题需确定后此接口才可定型
    BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException;


    /**
     * 获取订单详情
     *
     * @param trdOrderKey 第三方订单唯一标识，采用storeCode + trdOrderNo作为唯一标识
     * @return 返回第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException;

    /**
     * 订单号反查接口
     *
     * @param trdOrderKey@return 第三方供应商订单号
     */
    String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException;
}
