package outsideapi.exceptions;

import lombok.Data;

import java.security.PrivilegedActionException;

/**
 * 供应商接口调用异常
 * @author Liang Wenxu
 * @since 2018/7/19
 */
@Data
public class OrderCancelException extends Exception {
    /**
     * 错误代码枚举
     */
    public enum ERROR_CODES {
        /**
         * 取消订单失败，没有第三方订单号
         */
        TRD_ORDER_NOTFOUND("0001", "取消订单失败，没有第三方订单号"),
        /**
         * 第三方订单号不合法
         */
        ILLEGAL_TRD_ORDERNO("0002", "第三方订单号不合法"),
        /**
         * 第三方订单已确认发货或进入生产，无法通过接口取消
         */
        TRD_ORDER_COMFIRMED("1001", "取消订单失败，第三方订单已生产"),
        /**
         * 第三方接口返回报错
         */
        API_ERROR("1002", "第三方接口返回报错");


        private String value;
        private String message;
        ERROR_CODES(String value) {
            this.value = value;
            this.message = value;
        }
        ERROR_CODES(String value, String message) {
            this.value = value;
            this.message = message;
        }
        public String getValue() {
            return this.value;
        }
        public String getMessage() {
            return this.message;
        }
        @Override
        public String toString() {
            return value;
        }
    }

    /**
     * 错误代码
     */
    private ERROR_CODES errorCode;

    /**
     * Constructs a new exception with {@code null} as its detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     */
    public OrderCancelException(ERROR_CODES errorCode) {
        super(errorCode.getMessage());
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified detail message.  The
     * cause is not initialized, and may subsequently be initialized by
     * a call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public OrderCancelException(String message, ERROR_CODES errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public OrderCancelException(String message, ERROR_CODES errorCode, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified cause and a detail
     * message of <tt>(cause==null ? null : cause.toString())</tt> (which
     * typically contains the class and detail message of <tt>cause</tt>).
     * This constructor is useful for exceptions that are little more than
     * wrappers for other throwables (for example, {@link
     * PrivilegedActionException}).
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public OrderCancelException(ERROR_CODES errorCode, Throwable cause) {
        super(errorCode.getMessage(), cause);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified detail message,
     * cause, suppression enabled or disabled, and writable stack
     * trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @since 1.7
     */
    public OrderCancelException(String message, ERROR_CODES errorCode, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
    }
}
