package outsideapi.exceptions;

import lombok.Data;

import java.security.PrivilegedActionException;

/**
 * 供应商下单失败异常
 * @author Liang Wenxu
 * @since 2018/7/19
 */
@Data
public class SupplierTakeOrderFalidException extends Exception {
    /**
     * 错误代码枚举
     */
    public enum ERROR_CODES {
        /**
         * 供应商订单校验失败，从1001到1999
         */
        CHECK_FALID("1001", "供应商订单校验失败"),
        ADDRESS_TRANS_ERROR("1002", "无法找到对应的供应商地址"),

        CREATE_ORDER_COST_CHANGED("1003", "价格快照已过期"),
        /**
         * 在system_config中配置了下单预警拦截时，抛出此异常
         */
        TAKE_ORDER_INTERCEPTED("9001", "已拦截该供应商下单"),
        /**
         * 在system_config中配置了下单预警拦截配置项错误是抛出此异常
         */
        ILLEGAL_TAKE_ORDER_INTERCEPT_CONFIG("9000", "供应商下单预警拦截配置错误"),
        SUPPLIER_CUSTOM_ERROR("9000", "供应商自定义异常"),
        UNKNOWN("9999", "其他错误");



        private String value;
        private String message;
        ERROR_CODES(String value) {
            this.value = value;
            this.message = value;
        }
        ERROR_CODES(String value, String message) {
            this.value = value;
            this.message = message;
        }
        public String getValue() {
            return this.value;
        }
        public String getMessage() {
            return this.message;
        }
        @Override
        public String toString() {
            return value;
        }
    }

    /**
     * 错误代码
     */
    private ERROR_CODES errorCode;

    /**
     * Constructs a new exception with {@code null} as its detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     */
    public SupplierTakeOrderFalidException(ERROR_CODES errorCode) {
        super(errorCode.getMessage());
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified detail message.  The
     * cause is not initialized, and may subsequently be initialized by
     * a call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public SupplierTakeOrderFalidException(String message, ERROR_CODES errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public SupplierTakeOrderFalidException(String message, ERROR_CODES errorCode, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified cause and a detail
     * message of <tt>(cause==null ? null : cause.toString())</tt> (which
     * typically contains the class and detail message of <tt>cause</tt>).
     * This constructor is useful for exceptions that are little more than
     * wrappers for other throwables (for example, {@link
     * PrivilegedActionException}).
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public SupplierTakeOrderFalidException(ERROR_CODES errorCode, Throwable cause) {
        super(errorCode.getMessage(), cause);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new exception with the specified detail message,
     * cause, suppression enabled or disabled, and writable stack
     * trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @since 1.7
     */
    public SupplierTakeOrderFalidException(String message, ERROR_CODES errorCode, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
    }
}
