package outsideapi.utils;

/**
 * @author Liang Wenxu
 * @since 2018-06-11
 */
public class Constants {
    /**
     * 取消第三方订单处理结果代码{@value}: 成功
     */
    final String CANCEL_ORDER_CODE_SUCCESS = "0";
    /**
     * 取消第三方订单处理结果代码{@value}: 第三方接口处理失败
     */
    final String CANCEL_ORDER_CODE_API_ERROR = "1";
    /**
     * 取消第三方订单处理结果代码{@value}: 第三方订单已确认，不能取消
     */
    final String CANCEL_ORDER_CODE_TRD_ORDER_COMFIRMED = "2";

    public static final String SUCCESS="0";
    public static final String ERROR="1";
    public static final String TRDSP_ERROR="2";


    /**
     * 返回状态枚举
     */
    public enum ResponseStatus {
        SUCCESS("success"), ERROR("error"), TIME_OUT("timeout");
        private String code;
        ResponseStatus(String code) {
            this.code = code;
        }

        @Override
        public String toString() {
            return this.code;
        }
    }

    /**
     * 处理类接口名
     * OutsideApiHandler 售前相关，包括商品、运费等相关功能的处理器
     * OutsideOrderApiHandler 订单相关功能的处理器
     * OutsideAftersaleApiHandler 售后相关功能的处理器
     * SupplierOrderApiHandler 供应商订单相关功能处理器
     */
    public enum HandlerInterfaceNames {
        OUTSIDE_API_HANDLER("OutsideApiHandler"),
        OUTSIDE_ORDER_API_HANDLER("OutsideOrderApiHandler"),
        OUTSIDE_AFTERSALE_API_HANDLER("OutsideAftersaleApiHandler"),
        SUPPLIER_ORDER_API_HANDLER("SupplierOrderApiHandler");
        private String code;
        HandlerInterfaceNames(String code) {
            this.code = code;
        }

        @Override
        public String toString() {
            return this.code;
        }
    }
}
