package outsideapi.utils.jd;

import outsideapi.vo.jdorder.CSku;
import outsideapi.vo.jdorder.PSku;
import outsideapi.vo.order.TrdOrderSku;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Liang Wenxu on 2017-06-05.
 */
public class JdSkuUtil {

    public static List<TrdOrderSku> createTrdSkuByPSku(List<PSku> cskus){
        List<TrdOrderSku> skus = new ArrayList<TrdOrderSku>();
        for (PSku csku : cskus) {
            TrdOrderSku psku = new TrdOrderSku();
            psku.setCategory("" + csku.getCategory());
            psku.setNakedPrice(BigDecimal.valueOf(csku.getNakedprice()));
            psku.setName(csku.getName());
            psku.setNum(csku.getNum());
            psku.setOid("" + csku.getOid());
            psku.setPrice(BigDecimal.valueOf(csku.getPrice()));
            psku.setSkuId(csku.getSkuid());
            psku.setTax(BigDecimal.valueOf(csku.getTax()));
            psku.setTaxPrice(BigDecimal.valueOf(csku.getTaxprice()));
            psku.setType(String.valueOf(csku.getType()));
            skus.add(psku);
        }
        return skus;
    }

    public static List<TrdOrderSku> createTrdSkuByCSku(List<CSku> cskus){
        List<TrdOrderSku> skus = new ArrayList<TrdOrderSku>();
        for (CSku csku : cskus) {
            TrdOrderSku psku = new TrdOrderSku();
            psku.setCategory("" + csku.getCategory());
            psku.setNakedPrice(BigDecimal.valueOf(csku.getNakedprice()));
            psku.setName(csku.getName());
            psku.setNum(csku.getNum());
            psku.setOid("" + csku.getOid());
            psku.setPrice(BigDecimal.valueOf(csku.getPrice()));
            psku.setSkuId(csku.getSkuid());
            psku.setTax(BigDecimal.valueOf(csku.getTax()));
            psku.setTaxPrice(BigDecimal.valueOf(csku.getTaxprice()));
            psku.setType(String.valueOf(csku.getType()));
            skus.add(psku);
        }
        return skus;
    }
}