package outsideapi.vo;

import utils.Lang;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 批量产品规格价格查询参数VO
 * Created by Dy on 2017/04/15.
 */
public class FashionPriceRequestVo implements Serializable {

    private List<FashionPriceParamVo> fashionPriceParamVos;

    private String provinceCode; // 省（国标）
    private String cityCode; // 市（国标）
    private String countyCode; // 区（国标）
    private String townCode; // 街道
    private String storeId;  //店铺ID
    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }



    public FashionPriceRequestVo() {}

    public FashionPriceRequestVo(Map<Integer, String> areaNodeMap) {
        if(!Lang.isEmpty(areaNodeMap)) {
            this.provinceCode = areaNodeMap.get(1) == null ? "" : areaNodeMap.get(1);
            this.cityCode = areaNodeMap.get(2) == null ? "" : areaNodeMap.get(2);
            this.countyCode = areaNodeMap.get(3) == null ? "" : areaNodeMap.get(3);
            this.townCode =areaNodeMap.get(4) == null ? "" : areaNodeMap.get(4);
        }
    }

    public FashionPriceRequestVo(List<String> areaNodeList) {
        if(!Lang.isEmpty(areaNodeList)) {
            this.provinceCode = areaNodeList.size() >=1 && areaNodeList.get(0) != null ? areaNodeList.get(0) : "";
            this.cityCode = areaNodeList.size() >=2 && areaNodeList.get(1) != null ? areaNodeList.get(1) : "";
            this.countyCode = areaNodeList.size() >=3 && areaNodeList.get(2) != null ? areaNodeList.get(2) : "";
            this.townCode = areaNodeList.size() >=4 && areaNodeList.get(3) != null ? areaNodeList.get(3) : "";
        }
    }

    public List<FashionPriceParamVo> getFashionPriceParamVos() {
        return fashionPriceParamVos;
    }

    public void setFashionPriceParamVos(List<FashionPriceParamVo> fashionPriceParamVos) {
        this.fashionPriceParamVos = fashionPriceParamVos;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getTownCode() {
        return townCode;
    }

    public void setTownCode(String townCode) {
        this.townCode = townCode;
    }
}
