package outsideapi.vo;

import utils.Lang;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 第三方平台产品规格实时商品状态获取请求数据VO
 * Created by Liang Wenxu on 2016/11/11.
 */
public class FashionStatusRequetVo implements Serializable {
    private List<FashionNumsVo> fashionNums;
    private String provinceCode; // 省（国标）
    private String cityCode; // 市（国标）
    private String countyCode; // 区（国标）
    private String townCode; // 街道
    private String addrDetail;//详细地址
    private String storeId;


    /**
     * 采购方机构代码（可选）部分商品需要结合采购方机构进行可售性校验
     */
    private String companyId;

    public FashionStatusRequetVo() {
    }

    public FashionStatusRequetVo(List<FashionNumsVo> fashionNums, String provinceCode, String cityCode, String countyCode, String townCode, String addrDetail) {
        this.fashionNums = fashionNums;
        this.provinceCode = provinceCode;
        this.cityCode = cityCode;
        this.countyCode = countyCode;
        this.townCode = townCode;
        this.addrDetail = addrDetail;
    }

    public FashionStatusRequetVo(List<FashionNumsVo> fashionNums, String provinceCode, String cityCode, String countyCode, String townCode, String addrDetail, String companyId) {
        this.fashionNums = fashionNums;
        this.provinceCode = provinceCode;
        this.cityCode = cityCode;
        this.countyCode = countyCode;
        this.townCode = townCode;
        this.addrDetail = addrDetail;
        this.companyId = companyId;
    }

    /**
     * 从areaNodeList解析各级地址，areaNodeList Map以key=1为ProvinceCode，key=2为CityCode，key=3为CountyCode, key=4为TownCode，
     * @param areaNodeList
     */
    public void setAreasFromAreaNodeList(Map<Integer, String> areaNodeList) {
        this.setProvinceCode(areaNodeList.get(1));
        this.setCityCode(areaNodeList.get(2));
        this.setCountyCode(areaNodeList.get(3));
        this.setTownCode(areaNodeList.get(4));
    }

    /**
     * 从areaNodeList解析各级地址，areaNodeList List内以索引0为ProvinceCode，索引1为CityCode，索引2为CountyCode, 索引3为TownCode，
     * @param areaNodeList
     */
    public void setAreasFromAreaNodeList(List<String> areaNodeList) {
        if(!Lang.isEmpty(areaNodeList.get(0))) {
            this.setProvinceCode(areaNodeList.get(0));
        }
        if(!Lang.isEmpty(areaNodeList.get(1))) {
            this.setCityCode(areaNodeList.get(1));
        }
        if(!Lang.isEmpty(areaNodeList.get(2))) {
            this.setCountyCode(areaNodeList.get(2));
        }
        if(!Lang.isEmpty(areaNodeList.get(3))) {
            this.setTownCode(areaNodeList.get(3));
        }
    }

    public List<FashionNumsVo> getFashionNums() {
        return fashionNums;
    }

    public void setFashionNums(List<FashionNumsVo> fashionNums) {
        this.fashionNums = fashionNums;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getTownCode() {
        return townCode;
    }

    public void setTownCode(String townCode) {
        this.townCode = townCode;
    }

    public String getAddrDetail() {
        return addrDetail;
    }

    public void setAddrDetail(String addrDetail) {
        this.addrDetail = addrDetail;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }
}
