package outsideapi.vo;

import java.io.Serializable;

/**
 * Created by Liang Wenxu on 2016/11/24.
 */
public class FashionStockStateVo implements Serializable {
    public static final int STOCK_FLAG_NO_STOCK = 0; // 无货
    public static final int STOCK_FLAG_HAS_STOCK = 1; // 有货
    public static final int STOCK_FLAG_PRE_ORDER = 2; // 预定

    /**
     * 不可销售理由代码{@value}: 产品下架
     */
    public static final String NOTSALE_REASON_PRODUCT_DOWN = "1";

    /**
     * 不可销售理由代码{@value}: 机构无权购买该商品
     */
    public static final String NOTSALE_REASON_NOCOMPANY_PREM = "2";

    private String fashionId; // 规格ID

    private String productCode; // 第三方平台对应的产品代码

    Boolean onSale; // 是否可销售

    Integer stockCount; // 库存数量

    Boolean isAreaRestrict; // 是否限制销售地区

    Integer stockFlag; // 是否有货 0-- 无货，1--有货，2--预定（延后发货）

    /**
     * 限售原因，当onSale为false时可能有值
     * 取值见NOTSALE_REASON_开头常量
     */
    private String notsaleReason;

    public String getFashionId() {
        return fashionId;
    }

    public void setFashionId(String fashionId) {
        this.fashionId = fashionId;
    }

    public Boolean getOnSale() {
        return onSale;
    }

    public void setOnSale(Boolean onSale) {
        this.onSale = onSale;
    }

    public Integer getStockCount() {
        return stockCount;
    }

    public void setStockCount(Integer stockCount) {
        this.stockCount = stockCount;
    }

    public Boolean getAreaRestrict() {
        return isAreaRestrict;
    }

    public void setAreaRestrict(Boolean areaRestrict) {
        isAreaRestrict = areaRestrict;
    }

    public Boolean getIsAreaRestrict() {
        return isAreaRestrict;
    }

    public void setIsAreaRestrict(Boolean areaRestrict) {
        isAreaRestrict = areaRestrict;
    }


    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Integer getStockFlag() {
        return stockFlag;
    }

    public void setStockFlag(Integer stockFlag) {
        this.stockFlag = stockFlag;
    }

    public String getNotsaleReason() {
        return notsaleReason;
    }

    public void setNotsaleReason(String notsaleReason) {
        this.notsaleReason = notsaleReason;
    }
}
