package outsideapi.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * 外部供应商处理类Key类
 * @author Liang Wenxu
 * @since 2018-06-08
 */
@Data
public class HandlerKey implements Serializable {
    /**
     * 店铺代码{@value}: 不区分
     */
    public static final String STORE_CODE_ALL = "ALL";

    /**
     * 商品类型{@value}: 不区分
     */
    public static final String PRODUCT_TYPE_ALL = "ALL";
    /**
     * 店铺代码，如不按店铺代码区分，传入{@link HandlerKey#STORE_CODE_ALL}
     */
    private String storeCode;
    /**
     * 店铺类型
     */
    private String storeType;
    /**
     * 商品类型，如不按商品代码区分，传入{@link HandlerKey#PRODUCT_TYPE_ALL}
     */
    private String productType;

    /**
     * 处理类接口名
     * OutsideApiHandler 售前相关，包括商品、运费等相关功能的处理器
     * OutsideOrderApiHandler 订单相关功能的处理器
     * OutsideAftersaleApiHandler 售后相关功能的处理器
     */
    private String interfaceName;

    public String toKeyString() {
        return String.format("%s_%s_%s", storeType,
                storeCode == null ? STORE_CODE_ALL : storeCode,
                productType == null ? PRODUCT_TYPE_ALL : productType);
    }
}
