package outsideapi.vo;

import java.io.Serializable;

/**
 * 第三方接口统一适配处理器公共返回VO
 * Created by Liang Wenxu on 2016/11/24.
 */
public class HandlerRespVo<T> implements Serializable {
    /**
     * 返回处理状态：{@value} : 成功
     */
    public static final Integer RESPONSE_STATUS_SUCCESS = 1;
    /**
     * 返回处理状态：{@value} : 错误
     */
    public static final Integer RESPONSE_STATUS_ERROR = 0;

    public HandlerRespVo() {
    }

    /**
     * 快速结果集构造器，返回数据（处理成功）
     * @param data 返回数据
     */
    public HandlerRespVo(T data) {
        this.status = RESPONSE_STATUS_SUCCESS;
        this.errorCode = 0;
        this.message = "success";
        this.data = data;
    }

    /**
     * 快速结果集构造器，无数据的返回对象
     * @param status 处理结果状态
     * @param errorCode 错误代码
     * @param message 返回消息
     */
    public HandlerRespVo(Integer status, Integer errorCode, String message) {
        this.status = status;
        this.errorCode = errorCode;
        this.message = message;
        this.data = data;
    }

    /**
     * 快速结果集构造器，完整的自定义结果
     * @param status 处理结果状态
     * @param errorCode 错误代码
     * @param message 返回消息
     * @param data 返回数据，泛型，各接口实现可根据业务场景自行决定返回结果类型
     */
    public HandlerRespVo(Integer status, Integer errorCode, String message, T data) {
        this.status = status;
        this.errorCode = errorCode;
        this.message = message;
        this.data = data;
    }

    /**
     * 处理状态
     */
    private Integer status; //
    /**
     * 错误代码
     */
    private Integer errorCode; //
    /**
     * 返回消息
     */
    private String message; //
    /**
     * 返回数据
     */
    private T data; //

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
