package outsideapi.vo;

import java.io.Serializable;
import java.util.List;

/**
 * 订单物流包裹信息
 * <p>对应京东拆单后的子订单物流、苏宁的多个包裹</p>
 * @author Liang Wenxu
 * @since 2017-07-25
 * Created by Liang Wenxu on 2017-07-25.
 */
public class OrderShippingPackageVo implements Serializable {
    /**
     * 包裹标识
     * <p>京东存子订单号，苏宁存包裹id ,协议订单物流信息存物流单号</p>
     */
    private String packageId;

    /**
     * 物流名称
     */
    private String packageName;

    /**
     * 包裹里的商品订单号
     */
    private String trdSubOrderNo;
    /**
     * 预计收件时间（可为空）
     */
    private String receiveTime;
    /**
     * 送出时间（可为空）
     */
    private String shippingTime;
    /**
     * 跟踪信息栈
     */
    private List<OrderShippingTrackVo> trackInfoList;

    /**
     * 包裹商品信息
     */
    private List<GoodsInfoVo> goodsInfos;

    /**
     * 是否收货
     */
    private Boolean receiptsFlag;

    /**
     * 物流当前状态
     */
    private String status;

    /**
     * 包裹标识
     * <p>京东存子订单号，苏宁存包裹id</p>
     */
    public String getPackageId() {
        return this.packageId;
    }

    /**
     * 包裹标识
     * <p>京东存子订单号，苏宁存包裹id</p>
     */
    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    /**
     * 获取 预计收件时间（可为空）
     */
    public String getReceiveTime() {
        return this.receiveTime;
    }

    /**
     * 设置 预计收件时间（可为空）
     */
    public void setReceiveTime(String receiveTime) {
        this.receiveTime = receiveTime;
    }

    /**
     * 获取 送出时间（可为空）
     */
    public String getShippingTime() {
        return this.shippingTime;
    }

    /**
     * 设置 送出时间（可为空）
     */
    public void setShippingTime(String shippingTime) {
        this.shippingTime = shippingTime;
    }

    /**
     * 获取 跟踪信息栈
     */
    public List<OrderShippingTrackVo> getTrackInfoList() {
        return this.trackInfoList;
    }

    /**
     * 设置 跟踪信息栈
     */
    public void setTrackInfoList(List<OrderShippingTrackVo> trackInfoList) {
        this.trackInfoList = trackInfoList;
    }

    public String getTrdSubOrderNo() {
        return trdSubOrderNo;
    }

    public void setTrdSubOrderNo(String trdSubOrderNo) {
        this.trdSubOrderNo = trdSubOrderNo;
    }

    public List<GoodsInfoVo> getGoodsInfos() {
        return goodsInfos;
    }

    public void setGoodsInfos(List<GoodsInfoVo> goodsInfos) {
        this.goodsInfos = goodsInfos;
    }

    public Boolean getReceiptsFlag() {
        return receiptsFlag;
    }

    public void setReceiptsFlag(Boolean receiptsFlag) {
        this.receiptsFlag = receiptsFlag;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
