package outsideapi.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 供应商下单后的订单商品详情
 * @author Liang Wenxu
 * @since 2018-06-11
 */
@Data
public class OrderSkuResp implements Serializable {
    /**
     * 商品SKU
     */
    private String skuId;
    /**
     * 下单数量
     */
    private Integer num;
    /**
     * 分类代码（可选）
     */
    private String category;
    /**
     * 单价
     */
    private BigDecimal price;
    /**
     * 商品名称
     */
    private String name;
    /**
     * 税率
     */
    private BigDecimal tax;
    /**
     * 税额
     */
    private BigDecimal taxPrice;
    /**
     * 商品裸价（不含税金额）
     */
    private BigDecimal nakedPrice;
    /**
     * 0普通、1附件、2赠品
     */
    private String type;
    /**
     * 主商品sku，如果本身是主商品，则parentSku为0
     */
    private String parentSkuId;
}
