package outsideapi.vo.flgVo.inputVo;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import outsideapi.vo.flgVo.base.FlgBaseInputVo;
import utils.security.MD5Utils;

/**
 * Created by oracle on 2017-04-16.
 */
@Component
@ConfigurationProperties(prefix = "flgVariables")
public class FlgCardInputVo extends FlgBaseInputVo {
    /**
     * 编号	字段名称	报文名称	必填	最大长度	说明
     * 8	cardNo	卡号	否	16	用户的单用途卡
     * 9	cntactmobileNo	短信手机号	否	11	卡券卡号密码接收手机号（空表示不需要短信）
     * 10	productNos	产品代码列表	是		商品对应的代码，见商品查询接口（多个以英文逗号隔开）
     * 11	productNum	商品数量	是		多个以英文逗号隔开，必须与商品代码排序相同
     * 12	productSp	商品类型	是	2	{01：京东，02：一号店，03：亚马逊，04：天猫，XC:携程，BL:本来}
     *      token(父类中)	MD5	是		md5(productNum|productCd|md5key|loginId|userNm|firmNo|serialNumber)
     */
    public String cardNo;
    public String cntactmobileNo;
    public String productNos;
    public String productNum;
    public String productSp;

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getCntactmobileNo() {
        return cntactmobileNo;
    }

    public void setCntactmobileNo(String cntactmobileNo) {
        this.cntactmobileNo = cntactmobileNo;
    }

    public String getProductNos() {
        return productNos;
    }

    public void setProductNos(String productNos) {
        this.productNos = productNos;
    }

    public String getProductNum() {
        return productNum;
    }

    public void setProductNum(String productNum) {
        this.productNum = productNum;
    }

    public String getProductSp() {
        return productSp;
    }

    public void setProductSp(String productSp) {
        this.productSp = productSp;
    }

    @Override
    public void createToken(String md5key) {
        try {
            this.token = MD5Utils.encrypt(productNum + "|" + productCd + "|" + md5key + "|" + loginId + "|" + userNm + "|" + firmNo + "|" + serialNumber);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
