package outsideapi.vo.order;

import lombok.Data;
import utils.GlobalContants;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/7/19
 */
@Data
public class TrdOrder implements Serializable {
    /**
     * 父订单
     */
    public static final int TYPE_PARENT = 1;
    /**
     * 子订单
     */
    public static final int TYPE_CHILD = 2;

    /**
     * 订单状态：取消
     */
    public static final int ORDER_STATE_CANCELED = 0;
    /**
     * 订单状态：有效
     */
    public static final int ORDER_STATE_VALID = 1;

    /**
     * 物流状态：新建
     */
    public static final int STATE_NEW = 0;
    /**
     * 物流状态：妥投
     */
    public static final int STATE_FINISHED = 1;
    /**
     * 物流状态：拒收
     */
    public static final int STATE_REJECT = 2;

    /**
     * 订单确认状态：未确认下单
     */
    public static final int SUBMIT_STATE_UNSUBMIT = 0;
    /**
     * 订单确认状态：已确认下单
     */
    public static final int SUBMIT_STATE_SUBMITED = 1;



    /**
     * 第三方订单号
     */
    private String trdOrderNo;
    /**
     * 父订单的订单号
     */
    private String pOrderNo;

    /**
     * 订单类型：1 父订单 | 2 子订单
     */
    private int type;

    /**
     * 订单总价
     */
    private BigDecimal orderPrice;

    /**
     * 订单裸价（不含税价）
     */
    private BigDecimal orderNakedPrice;

    /**
     * 运费
     */
    private BigDecimal freight;

    /**
     * 订单状态
     */
    private int orderstate;

    /**
     * 物流状态
     */
    private int state;

    /**
     * 确认下单状态
     */
    private int submitstate;

    /**
     * 最终的订单状态
     */
    private GlobalContants.ORDER_STATUS finalStatus;

    /**
     * 商品列表，如为父订单，则包含所有子订单中的商品
     */
    private List<TrdOrderSku> sku;

    /**
     * 子订单列表
     */
    List<TrdOrder> corders;
}
