package outsideapi.vo.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018-06-12
 */

/**
 * 第三方订单信息
 */
@Data
public class TrdOrderInfo implements Serializable {
    // 物流状态：新建
    public static final String SHIPPING_STATE_NEW = "0";
    // 物流状态：妥投
    public static final String SHIPPING_STATE_FINISHED = "1";
    // 物流状态：拒收
    public static final String SHIPPING_STATE_REDJECTED = "2";
    // 物流状态：物流失败
    public static final String SHIPPING_STATE_FAILD = "9";

    /**
     * 订单类型{@value}: 父单
     */
    public static final String ORDER_TYPE_PARENT = "1";
    /**
     * 订单类型{@value}: 子单
     */
    public static final String ORDER_TYPE_CHILD = "2";

    /**
     * 订单确认状态{@value}: 已确认订单
     */
    public static final String ORDER_SUBMIT_STATE_SUBMITED = "1";
    /**
     * 订单确认状态{@value}: 未确认订单
     */
    public static final String ORDER_SUBMIT_STATE_UNSUBMIT = "0";

    /**
     * 订单状态{@value}: 取消订单
     */
    public static final String ORDER_STATE_CANCEL = "0";
    /**
     * 订单状态{@value}: 有效订单
     */
    public static final String ORDER_STATE_VALID = "1";
    /**
     * 订单状态{@value}: 错误订单
     */
    public static final String ORDER_STATE_ERROR = "9";

    /**
     * 订单裸价（不含税总价）
     */
    private BigDecimal orderNakedPrice;
    /**
     * 订单运费
     */
    private BigDecimal freight;
    /**
     * 订单总税额
     */
    private BigDecimal orderTaxPrice;
    /**
     * 订单总价
     */
    private BigDecimal orderPrice;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 父单单号，本身是父单或无拆单的供应商此字段为空
     */
    private String pOrder;
    /**
     * 订单物流状态：
     * 见{@link TrdOrderInfo}类中以"SHIPPING_STATE_"开头的常量
     */
    private String shippingState;
    /**
     * 订单类型   1是父订单   2是子订单
     * 见{@link TrdOrderInfo}类中以"ORDER_TYPE_"开头的常量
     */
    private String type;
    /**
     * 订单确认状态：<br/>
     * {@link TrdOrderInfo#ORDER_SUBMIT_STATE_SUBMITED}: 已确认订单<br/>
     * {@link TrdOrderInfo#ORDER_SUBMIT_STATE_UNSUBMIT}: 未确认订单
     */
    private String submitState;
    /**
     * 订单有效状态：<br/>
     * {@link TrdOrderInfo#ORDER_STATE_CANCEL}: 取消订单<br/>
     * {@link TrdOrderInfo#ORDER_STATE_VALID}: 有效订单<br/>
     * {@link TrdOrderInfo#ORDER_STATE_ERROR}: 错误订单订单
     */
    private String orderState;
    /**
     * 订单商品
     */
    private List<TrdOrderSku> sku;
}
