package outsideapi.vo.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 第三方订单信息-SKU信息
 * @author Liang Wenxu
 * @since 2018-06-12
 */
@Data
public class TrdOrderSku implements Serializable {
    /**
     * 商品类型{@value}: 普通
     */
    public static final String SKU_TYPE_NORMAL = "0";
    /**
     * 商品类型{@value}: 赠品
     */
    public static final String SKU_TYPE_GIFT = "1";
    /**
     * 商品类型{@value}: 附件
     */
    public static final String SKU_TYPE_ANNEX = "2";

    public static final String TYPE_GENERAL="0";//普通
    public static final String TYPE_ATTACHMENT="1";//附件
    public static final String TYPE_GIFT="2";//赠品


    /**
     * 商品裸价（不含税单价）
     */
    private BigDecimal nakedPrice;
    /**
     * 商品单价
     */
    private BigDecimal price;
    /**
     * 购买数量
     */
    private int num;
    /**
     * 商品名称
     */
    private String name;
    /**
     * 商品税额（单价）
     */
    private BigDecimal taxPrice;
    /**
     * 商品税率
     */
    private BigDecimal tax;
    /**
     * 商品分类（可选）
     */
    private String category;
    /**
     * 0普通、1附件、2赠品
     * {@link TrdOrderSku#SKU_TYPE_NORMAL}: 普通
     * {@link TrdOrderSku#SKU_TYPE_GIFT}: 赠品
     * {@link TrdOrderSku#SKU_TYPE_ANNEX}: 附件
     */
    private String type;
    /**
     * SKU
     */
    private String skuId;
    /**
     * 主商品SKU，如本身是主商品，此字段为0
     */
    private String pSku;
	
	/**
     * 当type不为0时，保存其归属的sku
     */
    private String oid;
	
    /**
     * 附属商品列表，包括赠品、附件
     */
    private List<TrdOrderSku> children;

}
