package outsideapi.vo.orderrequest;

import lombok.Data;

import java.io.Serializable;

/**
 * @author Liang Wenxu
 * @since 2018/8/8
 */
@Data
public class OrderReceiver implements Serializable {
    private String id;
    /**
     * 收件人姓名
     */
    private String username;

    private Boolean gender;
    //详细地址，不含省市区
    private String detailaddress;
    private String postCode; // 邮政编码
    /**
     * 电话
     */
    private String tel;
    /**
     * 手机
     */
    private String phone;
    private String extNumber;
    /**
     * 是否默认地址
     * 按每个类型【type】，可能会有多个默认地址
     */
    private Boolean isDefault;
    /*
     * 地址编号
     * */
    private String addressNo;

    /**
     * 类型，如jd ,suling 等
     */
    private String type;
    /**
     * 收件人邮箱
     */
    private String email;
    /**
     * 省代码（国标）
     */
    private String provinceCode;
    private String provinceName;
    /**
     * 市代码（国标）
     */
    private String cityCode;
    private String cityName;
    /**
     * 区
     */
    private String areaCode; // 区县代码（国标）
    private String areaName; // 区县名
    /**
     * 街道
     */
    private String townCode; // 街道编码（京东）
    private String townName; // 街道名

    private String countryCode; // 国家代码
    private String countryName; // 国家名


    //全地址
    private String addressDetail;
}
