package outsideapi.vo.orderrequest;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 订单基本信息Vo
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Data
public class OrderRequst extends OrderKey implements Serializable {
    /**
     * 临时订单号
     */
    private String tempOrderNo;
    /**
     * 父订单号
     */
    private String pOrder;
    /**
     * 订单归属店铺代码
     */
    private String storeCode;
    /**
     * 订单归属店铺名称
     */
    private String storeName;

    /**
     * 订单归属店铺类型
     */
    private String storeType;

    /**
     * 是否前往支付标志（用于集采或不需支付环节的订单），为true时跳转支付
     */
    private Boolean gotoPay;

    /**
     * 订单总金额（包含运费）
     */
    private BigDecimal sumPrice;

    /**
     * 订单商品总价（不含运费）
     */
    private BigDecimal sumNofreightPrice;

    /**
     * 订单基本运费
     */
    private BigDecimal freight;

    /**
     * 第三方订单金额
     */
    private BigDecimal orderPrice;

    /**
     * 第三方供应商订单号（如京东、苏宁的订单号）
     */
    private String thirdOrderNo;

    /**
     * 购买机构ID
     */
    private String companyId;

    /**
     * 支付信息
     */
    private OrderPaymentVo payment;

    /**
     * 收货人信息
     */
    private OrderReceiver orderReceiver;

    /**
     * 订单条目
     */
    private List<OrderItemVo> orderItems;

    /**
     * 子订单列表
     */
    private List<OrderRequst> subOrders;

    /**
     * 订单创建时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date createTime; //

    private String organizationId;

    private String organizationCode;

    /**
     * 下单时使用的goodsType
     */
    private String goodsType;

    /**
     * 订单模式，normal | batch 常规订单 | 批量订单 等
     */
    public String orderMode;

    /**
     * 库存预定单号
     */
    private String reservationCode;
}
