package outsideapi.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.GenericGenerator;
import outsideapi.model.base.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author Liang Wenxu
 * @since 2018-06-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "OUT_HANDLER_CONFIGS",
        indexes = {
                @Index(name = "IDX_O_HANDLER_CONF_STORE_CODE", columnList = "STORE_CODE")
        },
        uniqueConstraints = @UniqueConstraint(name = "UNQ_HANDLER_CONF",columnNames={"STORE_CODE", "PRODUCT_TYPE", "HANDLER_INTERFACE_NAME"})
)
public class OutsideapiHandlerConfigs extends BaseDomain implements Serializable {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id; // 主键

    /**
     * 店铺类型
     */
    @Column(name = "STORE_TYPE")
    private String storeType;

    /**
     * 店铺代码
     */
    @Column(name = "STORE_CODE")
    private String storeCode;

    /**
     * 产品类型
     */
    @Column(name = "PRODUCT_TYPE")
    private String productType;

    /**
     * 处理类的beanName
     */
    @Column(name = "HANDLER_BEAN")
    private String handlerBean;

    /**
     * 处理类接口名
     * OutsideApiHandler 售前相关，包括商品、运费等相关功能的处理器
     * OutsideOrderApiHandler 订单相关功能的处理器
     * OutsideAftersaleApiHandler 售后相关功能的处理器
     */
    @Column(name = "HANDLER_INTERFACE_NAME")
    private String handlerInterfaceName;

    @Column(name = "REMARKS")
    private String remarks;
}
