package outsideapi.model.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.io.Serializable;
import java.util.Date;

/**
 * Created by xiaoqian on 2015/5/21.
 */
@Data
@MappedSuperclass
abstract public class BaseDomain implements Serializable {

/*    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 32)
    protected String id;*/

    /**
     * 创建日期
     */
    @Column(name = "date_created")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateCreated;

    /**
     * 最后更新日期
     */
    @Column(name = "last_updated")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date lastUpdated;

    @Column(name = "version")
    private Integer version;

    @Column(name = "is_delete")
    private Boolean isDelete = false;

    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date deleteDate;

    @PrePersist
    protected void prePersist(){
        dateCreated = new Date();
        version = 1;
    }

    @PreUpdate
    private void preUpdate(){
        lastUpdated = new Date();
        if(version==null){
            version =1;
        }else{
            version++;
        }
    }
}
