/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.model.base;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

@MappedSuperclass
public abstract class BaseDomain
implements Serializable {
    @Column(name="date_created")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date dateCreated;
    @Column(name="last_updated")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date lastUpdated;
    @Column(name="version")
    private Integer version;
    @Column(name="is_delete")
    private Boolean isDelete = false;
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date deleteDate;

    @PrePersist
    protected void prePersist() {
        this.dateCreated = new Date();
        this.version = 1;
    }

    @PreUpdate
    private void preUpdate() {
        this.lastUpdated = new Date();
        if (this.version == null) {
            this.version = 1;
        } else {
            Integer n = this.version;
            Integer n2 = this.version = Integer.valueOf(this.version + 1);
        }
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Boolean getIsDelete() {
        return this.isDelete;
    }

    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDomain)) {
            return false;
        }
        BaseDomain other = (BaseDomain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$dateCreated = this.getDateCreated();
        Date other$dateCreated = other.getDateCreated();
        if (this$dateCreated == null ? other$dateCreated != null : !((Object)this$dateCreated).equals(other$dateCreated)) {
            return false;
        }
        Date this$lastUpdated = this.getLastUpdated();
        Date other$lastUpdated = other.getLastUpdated();
        if (this$lastUpdated == null ? other$lastUpdated != null : !((Object)this$lastUpdated).equals(other$lastUpdated)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Boolean this$isDelete = this.getIsDelete();
        Boolean other$isDelete = other.getIsDelete();
        if (this$isDelete == null ? other$isDelete != null : !((Object)this$isDelete).equals(other$isDelete)) {
            return false;
        }
        Date this$deleteDate = this.getDeleteDate();
        Date other$deleteDate = other.getDeleteDate();
        return !(this$deleteDate == null ? other$deleteDate != null : !((Object)this$deleteDate).equals(other$deleteDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseDomain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $dateCreated = this.getDateCreated();
        result = result * 59 + ($dateCreated == null ? 43 : ((Object)$dateCreated).hashCode());
        Date $lastUpdated = this.getLastUpdated();
        result = result * 59 + ($lastUpdated == null ? 43 : ((Object)$lastUpdated).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Boolean $isDelete = this.getIsDelete();
        result = result * 59 + ($isDelete == null ? 43 : ((Object)$isDelete).hashCode());
        Date $deleteDate = this.getDeleteDate();
        result = result * 59 + ($deleteDate == null ? 43 : ((Object)$deleteDate).hashCode());
        return result;
    }

    public String toString() {
        return "BaseDomain(dateCreated=" + this.getDateCreated() + ", lastUpdated=" + this.getLastUpdated() + ", version=" + this.getVersion() + ", isDelete=" + this.getIsDelete() + ", deleteDate=" + this.getDeleteDate() + ")";
    }
}

