package outsideapi.service.apiImpl;


import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;
import outsideapi.api.FlgApi;
import outsideapi.service.config.FlgVariablesConfig;
import outsideapi.service.utils.FlgVoReflectUtil;
import outsideapi.vo.flgVo.inputVo.FlgCardInputVo;
import outsideapi.vo.flgVo.outputVo.FlgCardOutputVo;

import java.util.UUID;


/**
 * Created by oracle on 2017-04-15.
 */
@MotanService
@Transactional
public class FlgApiImpl implements FlgApi {
    @Autowired
    FlgVariablesConfig flgVariablesConfig;

    @Autowired
    FlgCardInputVo flgCardInputVo;
    @Autowired
    FlgVoReflectUtil flgVoReflectUtil;
    @Autowired
    RestTemplate restTemplate;
    public static Logger logger = LoggerFactory.getLogger(FlgApiImpl.class);

    public FlgCardOutputVo flgCardApi(FlgCardInputVo flgCardInputVo) {
//        flgCardInputVo.setSerialNumber(UUID.randomUUID().toString());
        try {
            logger.info("=====================福利高卡券购买请求参数" + JSON.toJSONString(flgCardInputVo));
            //生成token
            flgCardInputVo.createToken(flgVariablesConfig.getFlgMd5Key());
            //福利高接口参数加密
            String params = flgVoReflectUtil.encryptVo(flgCardInputVo, flgVariablesConfig.getFlgAseKey());
            //发送接口请求
            FlgCardOutputVo flgCardOutputVo = restTemplate.postForObject(flgVariablesConfig.getFlgCardUrl() + params, flgCardInputVo, FlgCardOutputVo.class);

            //福利高接口参数解密
            flgVoReflectUtil.decryptVo(flgCardOutputVo, flgVariablesConfig.getFlgAseKey());
            logger.info("=====================福利高卡券购买请求响应参数" + JSON.toJSONString(flgCardOutputVo));
            return flgCardOutputVo;
        } catch (Exception e) {
            logger.error("=====================福利高卡券购买请求出错，错误信息:" + e.getMessage());
            throw new RuntimeException("福利高卡券购买请求出错" + e.getMessage());
        }
    }


}
