package outsideapi.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import outsideapi.api.OutsideOrderApi;
import outsideapi.exception.HandlerNotFoundException;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.handler.OutsideOrderApiHandler;
import outsideapi.service.service.stub.StoreApiStub;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.utils.Constants;
import outsideapi.vo.*;
import outsideapi.vo.order.OrderMainDto;
import outsideapi.vo.order.TrdOrderResp;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;

import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018-06-11
 */
@Component
@MotanService(basicService = "motanServerBasicConfig")
@Slf4j
public class OutsideOrderApiImpl implements OutsideOrderApi {

    @Override
    public CancelOrderResp cancelOrder(String storeId, String trdOrderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = getOutsideApiHandler(storeId);
        return handler.cancelOrder(trdOrderNo,storeId);
    }

    @Override
    public TakeOrderResp takeOrder(OrderMainDto orderMain) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = getOutsideApiHandler(orderMain.getStoreId());
        return handler.takeOrder(orderMain);
    }

    @Override
    public ConfirmOrderResp confirmOrder(String storeId, String trdOrderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = getOutsideApiHandler(storeId);
        return handler.confirmOrder(trdOrderNo,storeId);
    }

    @Override
    public BackOrderResp backOrder(OrderMainDto orderMain, List<String> skuIds) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = getOutsideApiHandler(orderMain.getStoreId());
        return handler.backOrder(orderMain, skuIds);
    }

    /**
     * 订单号反查接口
     * @param storeId 店铺ID
     * @param orderNo 集采订单号
     * @return 第三方供应商订单号
     */
    @Override
    public String queryTrdOrderNo(String storeId, String orderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = getOutsideApiHandler(storeId);
        return handler.queryTrdOrderNo(orderNo);
    }

    /**
     * 订单查询接口
     * @param storeId 店铺ID
     * @param trdOrderNo 第三方供应商订单号
     * @return
     */
    @Override
    public TrdOrderResp queryOrder(String storeId, String trdOrderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = getOutsideApiHandler(storeId);
        return handler.queryOrder(trdOrderNo);
    }

    /**
     * 获取第三方接口处理类
     *
     * @param storeId storeId
     * @return
     */
    private OutsideOrderApiHandler getOutsideApiHandler(String storeId) {
        long startTime = System.currentTimeMillis();
        StoreDto store = storeApi.findByStoreId(storeId);

        if (store != null && (!Lang.isEmpty(store.getId()) || store.getStoreExt() != null)) {
            OutsideOrderApiHandler handler = null;
            OutsideApiHandlerFactory factory = null;
            // 第三方接口处理类工厂网关
            factory = outsideApiFactoryUtil.getFactory();

            if (Lang.isEmpty(factory)) {
                throw new RuntimeException("outside.common.apihandler.factory not config !");
            }

            // 获取Handler
            HandlerKey handlerKey = new HandlerKey();
            handlerKey.setStoreType(store.getStoreExt().getType());
            handlerKey.setStoreCode(store.getStoreExt().getCode());
            handlerKey.setProductType(HandlerKey.PRODUCT_TYPE_ALL);
            handlerKey.setInterfaceName(Constants.HandlerInterfaceNames.OUTSIDE_ORDER_API_HANDLER.toString());
            handler = factory.getOutsideApiHandler(handlerKey, OutsideOrderApiHandler.class);
            if(handler == null) {
                throw new HandlerNotFoundException();
            }
            return handler;

        }
        throw new HandlerNotFoundException();
    }

    @Autowired
    StoreApiStub storeApi;

    @Autowired
    OutsideApiFactoryUtil outsideApiFactoryUtil;
}
