package outsideapi.service.controller;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.AddressCommonApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import outsideapi.api.OutsideProductApi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2017-08-06
 * Created by Liang Wenxu on 2017-08-06.
 */
@Controller
@RequestMapping("/test/areatrans")
public class TestAreaTransController {
    @RequestMapping("/suning")
    @ResponseBody
    public Object testSuning(Map model, String areaCode, HttpServletRequest request, HttpServletResponse response) {

        return outsideProductApi.transAreaCodeMap("4750f2b3-fbad-4b98-80ad-dc0801f38250", addressCommonApi.areaCodeNodeList(areaCode));
    }


    @RequestMapping("/jd")
    @ResponseBody
    public Object testJd(Map model, String areaCode, HttpServletRequest request, HttpServletResponse response) {

        return outsideProductApi.transAreaCodeMap("8ce42ec1-8c83-4f22-80c6-e31cdc0dab14", addressCommonApi.areaCodeNodeList(areaCode));
    }

    @Autowired
    OutsideProductApi outsideProductApi;

    @MotanReferer
    AddressCommonApi addressCommonApi;
}
