package outsideapi.service.factory.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;
import outsideapi.model.OutsideapiHandlerConfigs;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.OutsideApiService;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.vo.HandlerKey;
import utils.Lang;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * @author Liang Wenxu
 * @since 2018-06-08
 */
@Component("dbSpringBeanApiHandlerFactory")
public class DbSpringBeanApiHandlerFactory implements OutsideApiHandlerFactory, ApplicationContextAware {
    Logger logger = Logger.getLogger(DbSpringBeanApiHandlerFactory.class);

    private static String HANDLER_CACHE_KEY_TPL = "cache:outsideservice:apihandler:%s.%s";
    private static String HANDLER_INTF_PACKAGE = "outsideapi.service.handler";

    @Resource(name = "redisTemplate")
    private ValueOperations<String, Object> outsideHandlerCache;

    private ApplicationContext applicationContext;
    private OutsideApiFactoryUtil outsideApiFactoryUtil;

    @Autowired
    OutsideApiService outsideApiService;

    @Override
    public <T> T getOutsideApiHandler(HandlerKey handlerKey, Class<T> clazz) {
        if(handlerKey == null ||
                (Lang.isEmpty(handlerKey.getStoreType()) &&
                        Lang.isEmpty(handlerKey.getInterfaceName()) &&
                        Lang.isEmpty(handlerKey.getStoreCode()) &&
                        Lang.isEmpty(handlerKey.getProductType()))) {
            return null;
        }

        handlerKey.setInterfaceName(clazz.getSimpleName());

        T handler = getHandlerInCache(handlerKey, clazz);
        OutsideapiHandlerConfigs configs = outsideApiService.getHandlerConfigs(handlerKey);
        if(configs != null) {
            handler = (T) applicationContext.getBean(configs.getHandlerBean());
        }

        return handler;
    }

    @Override
    public OutsideApiHandler getOutsideApiHandlerByStoreType(String storeType) {
        return null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext= applicationContext;
    }

    /**
     * 从缓存获取处理器
     * @param handlerKey
     * @param clazz
     * @param <T>
     * @return
     */
    private  <T> T getHandlerInCache(HandlerKey handlerKey, Class<T> clazz) {
        Object obj = outsideHandlerCache.get(String.format(HANDLER_CACHE_KEY_TPL,
                clazz.getSimpleName(), handlerKey.toKeyString()));

        return (T) obj;
    }

    /**
     * 设置处理器到缓存
     * @param handlerKey
     * @param value
     */
    private <T> void putHandlerToCache(HandlerKey handlerKey, T value) {
        outsideHandlerCache.set(String.format(HANDLER_CACHE_KEY_TPL,
                value.getClass().getSimpleName(), handlerKey.toKeyString()),
                value, 10, TimeUnit.MINUTES);
    }
}
