package outsideapi.service.factory.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.vo.HandlerKey;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;

/**
 * 根据预先定义的ApiHandler SpringBean 的Name来获取ApiHandler对象工厂实现
 * Created by Liang Wenxu on 2016/11/24.
 * @deprecated 迁移到DbSpringBeanApiHandlerFactory实现
 */
@Deprecated
public class SpringBeanApiHandlerFactory implements OutsideApiHandlerFactory, ApplicationContextAware {
    Logger logger = Logger.getLogger(SpringBeanApiHandlerFactory.class);

    private ApplicationContext applicationContext;
    private OutsideApiFactoryUtil outsideApiFactoryUtil;


    static {

    }

    public OutsideApiHandler getOutsideApiHandlerByStore(String storeKey) {
        OutsideApiHandler handler = getOutsideApiHandlerByStoreCode(storeKey);
        if(handler == null) {
            StoreDto store = getOutsideApiFactoryUtil().findStoreById(storeKey);
            if(store != null) {
                handler = getOutsideApiHandlerByStoreCode(store.getStoreExt().getCode());
            }
        }

        return handler;
    }

    public OutsideApiHandler getOutsideApiHandlerByStoreCode(String storeCode) {
        String configKey = "outside.common.apihandler.bean." + storeCode;
        String beanName = getOutsideApiFactoryUtil().readProp(configKey);
        logger.info("read config: ["+configKey+": "+beanName+"]");
        if(!Lang.isEmpty(beanName)) {
            OutsideApiHandler handlerBean = (OutsideApiHandler) applicationContext.getBean(beanName);

            if(handlerBean != null) {
//                InvocationHandler proxy = new OutsideApiHandlerProxy(applicationContext.getBean(beanName));
//
//                OutsideApiHandler outsideApiHandler = (OutsideApiHandler) Proxy.newProxyInstance(
//                        proxy.getClass().getClassLoader(), handlerBean.getClass().getInterfaces(), proxy);

                return handlerBean;
            }
        }
        return null;
    }

    private OutsideApiFactoryUtil getOutsideApiFactoryUtil() {
        if(outsideApiFactoryUtil == null) {
            outsideApiFactoryUtil = (OutsideApiFactoryUtil) applicationContext.getBean("outsideApiFactoryUtil");
        }

        return outsideApiFactoryUtil;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public <T> T getOutsideApiHandler(HandlerKey handlerKey, Class<T> clazz) {
        return null;
    }

    @Override
    public OutsideApiHandler getOutsideApiHandlerByStoreType(String storeType) {
        return null;
    }
}
