package outsideapi.service.factory.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.vo.HandlerKey;
import utils.Lang;

/**
 * 根据预先定义的ApiHandler SpringBean 的Name来获取ApiHandler对象工厂实现
 * Created by Liang Wenxu on 2016/11/24.
 * @deprecated 迁移到DbSpringBeanApiHandlerFactory实现
 */
@Component
@Deprecated
public class StoreTypeSpringBeanApiHandlerFactory implements OutsideApiHandlerFactory, ApplicationContextAware {
    Logger logger = Logger.getLogger(StoreTypeSpringBeanApiHandlerFactory.class);

    private ApplicationContext applicationContext;
    private OutsideApiFactoryUtil outsideApiFactoryUtil;

    static {

    }

    public OutsideApiHandler getOutsideApiHandlerByStore(String storeKey) {
        String beanName = "protocolOutsideApiHandler";
        if(!Lang.isEmpty(beanName)) {
            OutsideApiHandler handlerBean = (OutsideApiHandler) applicationContext.getBean(beanName);
            if(handlerBean != null) {
                return handlerBean;
            }
        }
        return null;
    }

    public OutsideApiHandler getOutsideApiHandlerByStoreCode(String storeCode) {
        String beanName = "protocolOutsideApiHandler";
        if(!Lang.isEmpty(beanName)) {
            OutsideApiHandler handlerBean = (OutsideApiHandler) applicationContext.getBean(beanName);

            if(handlerBean != null) {
//                InvocationHandler proxy = new OutsideApiHandlerProxy(applicationContext.getBean(beanName));
//
//                OutsideApiHandler outsideApiHandler = (OutsideApiHandler) Proxy.newProxyInstance(
//                        proxy.getClass().getClassLoader(), handlerBean.getClass().getInterfaces(), proxy);

                return handlerBean;
            }
        }
        return null;
    }

    @Override
    public OutsideApiHandler getOutsideApiHandlerByStoreType(String storeType) {
        String beanName = "trdspOutsideApiHandler";
        if(!Lang.isEmpty(beanName)) {
            OutsideApiHandler handlerBean = (OutsideApiHandler) applicationContext.getBean(beanName);
            if(handlerBean != null) {
                return handlerBean;
            }
        }
        return null;
    }

    private OutsideApiFactoryUtil getOutsideApiFactoryUtil() {
        if(outsideApiFactoryUtil == null) {
            outsideApiFactoryUtil = (OutsideApiFactoryUtil) applicationContext.getBean("outsideApiFactoryUtil");
        }

        return outsideApiFactoryUtil;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public <T> T getOutsideApiHandler(HandlerKey handlerKey, Class<T> clazz) {
        return null;
    }
}
