package outsideapi.service.handler;

import member.api.AddressCommonApi;
import outsideapi.vo.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * Created by Liang Wenxu on 2016/11/24.
 */
public interface OutsideApiHandler {
    /**
     * 查询产品规格对应的第三方库存信息
     * @param requet FashionStatusRequetVo
     * @return
     */
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet);

    /**
     * 价格适配
     * @param requet
     * @return
     */
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet);

    /**
     * 查询第三方配送费用
     * @param requet ShippingFeeRequetVo
     * @return HandlerRespVo<Map<String, Object>>
     *     返回的data示意：
     *     data:[
     *          freight: BigDecimal, // 总运费
     *          baseFreight: BigDecimal, // 基础运费
     *          remoteRegionFreight: BigDecimal, // 偏远运费
     *          remoteFashions: String, // 需收取偏远运费的Fashion的id,多个ID使用","连接
     *     ]
     */
    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet);

    /**
     * 转换国标地区码为第三方接口专用地区码
     * @param areaCode 集采地区代码
     * @param lv 层级
     * @return
     */
    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv);

    /**
     * 转换国标地址代码集合为第三方地址代码集合，集合中key为地区层级，各层级见AddressCommonApi.AddressLevel
     * @param areaMap 集采地址集合
     * @return
     */
    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap);

    /**
     * 获取商品用于费率查询的区间基准值，京东为 协议价 / 市场价
     * @param fashionPricesRequestVo
     * @return
     */
    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo);


    // TODO 先注释，目前似乎没用到
    /**
     * 订单物流详细
     * @param requet
     * @return
     */
    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet);


    /**
     * 厂送商品确认收货
     * @param requst
     * @return
     */
    public HandlerRespVo<Map<String,Object>> facProductConfirm(FacProductConfirmRequestVo requst);

    /**
     * 物流时效
     * @param requet
     * @return
     */
    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet);

    /**
     * 获取订单物流状态
     * @param trdOrderNo 第三方订单号
     * @return
     */
    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo);

    /**
     * 获取供应商订单状态
     * @param trdOrderNo 第三方订单号
     * @return 返回的状态码为OutsideProductApi中，以TRD_ORDER_STATUS_开头的常量
     */
    public HandlerRespVo<String> getOrderStatus(String trdOrderNo);

    /**
     * 获取第三方订单状态
     * @param trdOrderNo
     * @param storeId
     * @return 返回的状态码为OutsideProductApi中，以TRD_ORDER_STATUS_开头的常量
     */
    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo,String storeId);

    /**
     * 获取订单物流状态（针对诚通没有分包裹使用老代码）
     * @param trdOrderNo 第三方订单号
     * @return
     */
    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo);

    /**
     * 生成预占单
     * @param reserveOrderVo
     * @param storeCode
     * @return 预订单ｉｄ对象
     */
    HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode);


    /**
     * 删除预占单　
     * @param reserveOrderIdVo
     * @param storeCode
     * @return true/false
     */
    HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode);
}
