package outsideapi.service.handler;

import outsideapi.vo.BackOrderResp;
import outsideapi.vo.CancelOrderResp;
import outsideapi.vo.ConfirmOrderResp;
import outsideapi.vo.TakeOrderResp;
import outsideapi.vo.order.OrderMainDto;
import outsideapi.vo.order.TrdOrderResp;

import java.util.List;

/**
 * 第三方供应商订单相关接口处理器
 * @author Liang Wenxu
 * @since 2018-06-11
 */
public interface OutsideOrderApiHandler {
    /**
     * 取消订单
     * @param trdOrderNo 第三方订单号
     * @param storeId
     * @return 第三方订单取消状态；包括如下字段：
     *            status: {@link outsideapi.utils.Constants.ResponseStatus#SUCCESS} 成功 | {@link outsideapi.utils.Constants.ResponseStatus#ERROR} 失败
     *            code: 通常在status=error时有意义，返回错误代码：
     *                0 - 无错误
     *                1 - 第三方订单取消失败
     *                2 - 第三方订单已经确认
     *            message: 通常在status=error时有意义，返回错误信息
     */
    CancelOrderResp cancelOrder(String trdOrderNo, String storeId);

    /**
     * 第三方下单（预占库存）
     * @param orderMain
     * @return
     */
    TakeOrderResp takeOrder(OrderMainDto orderMain);

    /**
     * 第三方订单确认（确认下单）
     * @param trdOrderNo 第三方订单号
     * @param storeId
     * @return
     */
    ConfirmOrderResp confirmOrder(String trdOrderNo, String storeId);

    /**
     * 第三方退货
     * @param orderMain 退货的订单
     * @param skuIds 指定退货的SKU（部分退货）
     * @return
     */
    BackOrderResp backOrder(OrderMainDto orderMain, List<String> skuIds);

    /**
     * 订单号反查接口
     * @param orderNo 集采订单号
     * @return 第三方供应商订单号
     */
    String queryTrdOrderNo(String orderNo);

    /**
     * 订单查询接口
     * @param trdOrderNo 第三方供应商订单号
     * @return
     */
    TrdOrderResp queryOrder(String trdOrderNo);
}
