package outsideapi.service.handler;

import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.orderrequest.OrderRequst;

import java.util.List;

/**
 * 第三方供应商订单相关接口处理器
 * @author Liang Wenxu
 * @since 2018-06-11
 */
public interface SupplierOrderApiHandler {

    /**
     * 订单号反查接口
     *
     * @param trdOrderKey@return 第三方供应商订单号
     */
    String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException;

    /**
     * 向第三方供应商下单
     * @param orderRequst 商城订单信息
     * @return 返回生产成功的第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口调用异常
     * @throws SupplierTakeOrderFalidException 供应商下单失败异常
     */
    TrdOrder takeOrder(OrderRequst orderRequst) throws SupplierInterfaceInvokeException, SupplierTakeOrderFalidException;

    /**
     * 确认下单，调用时记得处理所有的异常噢！
     * @param orderMain 商城订单信息
     * @throws SupplierInterfaceInvokeException 供应商接口调用异常
     * @throws SupplierOrderComfirmFalidException 供应商下单失败异常，其中错误代码3103表示已确认下单无需重复确认
     */
    void confirmOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException;

    /**
     * 第三方退货
     * @param orderMain 商城订单信息
     * @param skuIds 退货的商品
     * @return
     * @throws SupplierInterfaceInvokeException
     */
    BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException;


    /**
     * 获取订单详情
     * @param trdOrderKey 第三方订单唯一标识，采用storeCode + trdOrderNo作为唯一标识
     * @return 返回第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException;

    /**
     * 取消订单
     * @param trdOrderKey 第三方订单唯一标识，采用storeCode + trdOrderNo作为唯一标识
     * @return 返回true取消成功，否则为false
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    Boolean cancelOrder(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException, OrderCancelException;

    /**
     * 获取订单物流状态
     * @param trdOrderNo 第三方订单号
     * @return
     */
    public List<OrderShippingPackageVo> getShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException;

    /**
     * 获取供应商订单状态
     * @param trdOrderNo 第三方订单号
     * @return 供应商订单号
     */
    public String getOrderStatus(String trdOrderNo) throws SupplierInterfaceInvokeException;

    /**
     * 获取订单物流状态（针对诚通没有分包裹使用老代码）
     * @param trdOrderNo 第三方订单号
     * @return
     */
    public List<OrderShippingPackageVo> getCTShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException;
}
